/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.authn;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.AuthnContextClassRefBuilder;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.InetAddressUtils;
import org.apereo.cas.util.RandomUtils;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlAuthNStatementBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<AuthnStatement> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlAuthNStatementBuilder.class);
    private static final long serialVersionUID = 8761566449790497226L;
    private final transient AuthnContextClassRefBuilder authnContextClassRefBuilder;
    private final CasConfigurationProperties casProperties;

    public SamlProfileSamlAuthNStatementBuilder(OpenSamlConfigBean configBean, AuthnContextClassRefBuilder authnContextClassRefBuilder, CasConfigurationProperties casProperties) {
        super(configBean);
        this.authnContextClassRefBuilder = authnContextClassRefBuilder;
        this.casProperties = casProperties;
    }

    @Override
    public AuthnStatement build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        return this.buildAuthnStatement(assertion, authnRequest, adaptor, service, binding, messageContext, request);
    }

    private AuthnStatement buildAuthnStatement(Object casAssertion, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService service, String binding, MessageContext messageContext, HttpServletRequest request) throws SamlException {
        Object id;
        Assertion assertion = (Assertion)Assertion.class.cast(casAssertion);
        String authenticationMethod = this.authnContextClassRefBuilder.build(assertion, authnRequest, adaptor, service);
        Object object = id = request != null ? CommonUtils.safeGetParameter((HttpServletRequest)request, (String)"ticket") : "";
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.warn("Unable to locate service ticket as the session index; Generating random identifier instead...");
            id = "_" + String.valueOf(RandomUtils.nextLong());
        }
        AuthnStatement statement = this.newAuthnStatement(authenticationMethod, DateTimeUtils.zonedDateTimeOf((Date)assertion.getAuthenticationDate()), (String)id);
        if (assertion.getValidUntilDate() != null) {
            ZonedDateTime dt = DateTimeUtils.zonedDateTimeOf((Date)assertion.getValidUntilDate());
            int skewAllowance = service.getSkewAllowance() > 0 ? service.getSkewAllowance() : this.casProperties.getAuthn().getSamlIdp().getResponse().getSkewAllowance();
            statement.setSessionNotOnOrAfter(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)dt.plusSeconds(skewAllowance)));
        }
        SubjectLocality subjectLocality = this.buildSubjectLocality(assertion, authnRequest, adaptor, binding);
        statement.setSubjectLocality(subjectLocality);
        return statement;
    }

    protected SubjectLocality buildSubjectLocality(Object assertion, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding) throws SamlException {
        SubjectLocality subjectLocality = (SubjectLocality)this.newSamlObject(SubjectLocality.class);
        String hostAddress = InetAddressUtils.getCasServerHostAddress((String)this.casProperties.getServer().getName());
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
        LOGGER.debug("Built subject locality address [{}] for the saml authentication statement prepped for [{}]", (Object)hostAddress, (Object)issuer);
        subjectLocality.setAddress(hostAddress);
        return subjectLocality;
    }
}

