/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPAlgorithmsProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.WhitelistBlacklistConfiguration;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicEncryptionParametersResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.DEREncodedKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.KeyInfoReferenceProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlIdPObjectEncrypter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPObjectEncrypter.class);
    private final SamlIdPProperties samlIdPProperties;

    public EncryptedAssertion encode(Assertion samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        Encrypter encrypter = this.buildEncrypterForSamlObject(samlObject, service, adaptor);
        if (encrypter != null) {
            return encrypter.encrypt(samlObject);
        }
        String entityId = adaptor.getEntityId();
        if (service.isEncryptionOptional()) {
            LOGGER.debug("Skipping to encrypt assertion; No encrypter can be determined and encryption is optional for [{}]", (Object)entityId);
            return null;
        }
        throw new SamlException("Unable to encrypt assertion for " + entityId);
    }

    public EncryptedID encode(NameID samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        Encrypter encrypter = this.buildEncrypterForSamlObject(samlObject, service, adaptor);
        if (encrypter != null) {
            return encrypter.encrypt(samlObject);
        }
        String entityId = adaptor.getEntityId();
        if (service.isEncryptionOptional()) {
            LOGGER.debug("Skipping to encrypt Name ID; No encrypter can be determined and encryption is optional for [{}]", (Object)entityId);
            return null;
        }
        throw new SamlException("Unable to encrypt Name ID for " + entityId);
    }

    public EncryptedAttribute encode(Attribute samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        Encrypter encrypter = this.buildEncrypterForSamlObject(samlObject, service, adaptor);
        if (encrypter != null) {
            return encrypter.encrypt(samlObject);
        }
        String entityId = adaptor.getEntityId();
        if (service.isEncryptionOptional()) {
            LOGGER.debug("Skipping to encrypt attribute; No encrypter can be determined and encryption is optional for [{}]", (Object)entityId);
            return null;
        }
        throw new SamlException("Unable to encrypt attribute for " + entityId);
    }

    protected Encrypter buildEncrypterForSamlObject(Object samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        String entityId = adaptor.getEntityId();
        LOGGER.trace("Calculating encryption security configuration for [{}] based on service [{}]", (Object)entityId, (Object)service.getName());
        BasicEncryptionConfiguration encryptionConfiguration = this.configureEncryptionSecurityConfiguration(service);
        LOGGER.trace("Fetching key encryption credential for [{}] based on service [{}]", (Object)entityId, (Object)service.getName());
        this.configureKeyEncryptionCredential(entityId, adaptor, service, encryptionConfiguration);
        LOGGER.trace("Fetching key encryption parameters for [{}] based on service [{}]", (Object)entityId, (Object)service.getName());
        KeyEncryptionParameters keyEncParams = this.getKeyEncryptionParameters(samlObject, service, adaptor, encryptionConfiguration);
        if (keyEncParams != null) {
            LOGGER.trace("Key encryption algorithm for [{}] is [{}]", (Object)keyEncParams.getRecipient(), (Object)keyEncParams.getAlgorithm());
        }
        LOGGER.trace("Fetching data encryption parameters for [{}] based on service [{}]", (Object)entityId, (Object)service.getName());
        DataEncryptionParameters dataEncParams = this.getDataEncryptionParameters(samlObject, service, adaptor, encryptionConfiguration);
        if (dataEncParams != null) {
            LOGGER.trace("Data encryption algorithm for [{}] is [{}]", (Object)entityId, (Object)dataEncParams.getAlgorithm());
        }
        LOGGER.trace("Building encrypter component for [{}]", (Object)entityId);
        return this.getEncrypter(samlObject, service, adaptor, keyEncParams, dataEncParams);
    }

    protected Encrypter getEncrypter(Object samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, KeyEncryptionParameters keyEncParams, DataEncryptionParameters dataEncParams) {
        String entityId = adaptor.getEntityId();
        if (keyEncParams == null || dataEncParams == null) {
            LOGGER.warn("No key/data encryption parameters could be determined for [{}]", (Object)entityId);
            return null;
        }
        String className = samlObject.getClass().getName();
        Encrypter encrypter = new Encrypter(dataEncParams, keyEncParams);
        encrypter.setKeyPlacement(Encrypter.KeyPlacement.PEER);
        LOGGER.debug("Attempting to encrypt [{}] for [{}] with key placement of [{}]", new Object[]{className, entityId, encrypter.getKeyPlacement()});
        return encrypter;
    }

    protected DataEncryptionParameters getDataEncryptionParameters(Object samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, BasicEncryptionConfiguration encryptionConfiguration) {
        try {
            EncryptionParameters params = this.resolveEncryptionParameters(service, encryptionConfiguration);
            if (params != null) {
                return new DataEncryptionParameters(params);
            }
            LOGGER.debug("No data encryption parameters could be determined");
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected KeyEncryptionParameters getKeyEncryptionParameters(Object samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, BasicEncryptionConfiguration encryptionConfiguration) {
        try {
            EncryptionParameters params = this.resolveEncryptionParameters(service, encryptionConfiguration);
            if (params != null) {
                return new KeyEncryptionParameters(params, adaptor.getEntityId());
            }
            LOGGER.debug("No key encryption parameters could be determined");
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Credential configureKeyEncryptionCredential(String peerEntityId, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService service, BasicEncryptionConfiguration encryptionConfiguration) throws Exception {
        MetadataCredentialResolver kekCredentialResolver = new MetadataCredentialResolver();
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new RSAKeyValueProvider());
        providers.add(new DSAKeyValueProvider());
        providers.add(new InlineX509DataProvider());
        providers.add(new DEREncodedKeyValueProvider());
        providers.add(new KeyInfoReferenceProvider());
        BasicProviderKeyInfoCredentialResolver keyInfoResolver = new BasicProviderKeyInfoCredentialResolver(providers);
        kekCredentialResolver.setKeyInfoCredentialResolver((KeyInfoCredentialResolver)keyInfoResolver);
        RoleDescriptorResolver roleDescriptorResolver = SamlIdPUtils.getRoleDescriptorResolver((SamlRegisteredServiceServiceProviderMetadataFacade)adaptor, (boolean)this.samlIdPProperties.getMetadata().isRequireValidMetadata());
        kekCredentialResolver.setRoleDescriptorResolver(roleDescriptorResolver);
        kekCredentialResolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EncryptionConfigurationCriterion(new EncryptionConfiguration[]{encryptionConfiguration}));
        criteriaSet.add((Object)new EntityIdCriterion(peerEntityId));
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        criteriaSet.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
        LOGGER.debug("Attempting to resolve the encryption key for entity id [{}]", (Object)peerEntityId);
        Credential credential = kekCredentialResolver.resolveSingle(criteriaSet);
        if (credential == null || credential.getPublicKey() == null) {
            throw new IllegalArgumentException("Unable to resolve the encryption [public] key for entity id " + peerEntityId);
        }
        String encodedKey = EncodingUtils.encodeBase64((byte[])credential.getPublicKey().getEncoded());
        LOGGER.debug("Found encryption public key: [{}]", (Object)encodedKey);
        encryptionConfiguration.setKeyTransportEncryptionCredentials(CollectionUtils.wrapList((Object[])new Credential[]{credential}));
        return credential;
    }

    protected EncryptionParameters resolveEncryptionParameters(SamlRegisteredService service, BasicEncryptionConfiguration encryptionConfiguration) throws ResolverException {
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new EncryptionConfigurationCriterion(new EncryptionConfiguration[]{encryptionConfiguration}));
        criteria.add((Object)new EncryptionOptionalCriterion(service.isEncryptionOptional()));
        return new BasicEncryptionParametersResolver().resolveSingle(criteria);
    }

    protected BasicEncryptionConfiguration configureEncryptionSecurityConfiguration(SamlRegisteredService service) {
        List overrideWhiteListedAlgorithms;
        List overrideBlackListedEncryptionAlgorithms;
        List overrideKeyEncryptionAlgorithms;
        List overrideDataEncryptionAlgorithms;
        BasicEncryptionConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration();
        LOGGER.trace("Default encryption blacklisted algorithms: [{}]", (Object)config.getBlacklistedAlgorithms());
        LOGGER.trace("Default encryption key algorithms: [{}]", (Object)config.getKeyTransportEncryptionAlgorithms());
        LOGGER.trace("Default encryption data algorithms: [{}]", (Object)config.getDataEncryptionAlgorithms());
        LOGGER.trace("Default encryption whitelisted algorithms: [{}]", (Object)config.getWhitelistedAlgorithms());
        SamlIdPAlgorithmsProperties globalAlgorithms = this.samlIdPProperties.getAlgs();
        List list = overrideDataEncryptionAlgorithms = service.getEncryptionDataAlgorithms().isEmpty() ? globalAlgorithms.getOverrideDataEncryptionAlgorithms() : service.getEncryptionDataAlgorithms();
        if (overrideDataEncryptionAlgorithms != null && !overrideDataEncryptionAlgorithms.isEmpty()) {
            config.setDataEncryptionAlgorithms(overrideDataEncryptionAlgorithms);
        }
        List list2 = overrideKeyEncryptionAlgorithms = service.getEncryptionKeyAlgorithms().isEmpty() ? globalAlgorithms.getOverrideKeyEncryptionAlgorithms() : service.getEncryptionKeyAlgorithms();
        if (overrideKeyEncryptionAlgorithms != null && !overrideKeyEncryptionAlgorithms.isEmpty()) {
            config.setKeyTransportEncryptionAlgorithms(overrideKeyEncryptionAlgorithms);
        }
        List list3 = overrideBlackListedEncryptionAlgorithms = service.getEncryptionBlackListedAlgorithms().isEmpty() ? globalAlgorithms.getOverrideBlackListedEncryptionAlgorithms() : service.getEncryptionBlackListedAlgorithms();
        if (overrideBlackListedEncryptionAlgorithms != null && !overrideBlackListedEncryptionAlgorithms.isEmpty()) {
            config.setBlacklistedAlgorithms((Collection)overrideBlackListedEncryptionAlgorithms);
        }
        List list4 = overrideWhiteListedAlgorithms = service.getEncryptionWhiteListedAlgorithms().isEmpty() ? globalAlgorithms.getOverrideWhiteListedAlgorithms() : service.getEncryptionWhiteListedAlgorithms();
        if (overrideWhiteListedAlgorithms != null && !overrideWhiteListedAlgorithms.isEmpty()) {
            config.setWhitelistedAlgorithms((Collection)overrideWhiteListedAlgorithms);
        }
        LOGGER.trace("Finalized encryption blacklisted algorithms: [{}]", (Object)config.getBlacklistedAlgorithms());
        LOGGER.trace("Finalized encryption key algorithms: [{}]", (Object)config.getKeyTransportEncryptionAlgorithms());
        LOGGER.trace("Finalized encryption data algorithms: [{}]", (Object)config.getDataEncryptionAlgorithms());
        LOGGER.trace("Finalized encryption whitelisted algorithms: [{}]", (Object)config.getWhitelistedAlgorithms());
        if (StringUtils.isNotBlank((CharSequence)service.getWhiteListBlackListPrecedence())) {
            WhitelistBlacklistConfiguration.Precedence precedence = WhitelistBlacklistConfiguration.Precedence.valueOf((String)service.getWhiteListBlackListPrecedence().trim().toUpperCase());
            config.setWhitelistBlacklistPrecedence(precedence);
        }
        return config;
    }

    @Generated
    public SamlIdPObjectEncrypter(SamlIdPProperties samlIdPProperties) {
        this.samlIdPProperties = samlIdPProperties;
    }
}

