/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc;

import com.google.common.collect.Sets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPAlgorithmsProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPResponseProperties;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.crypto.CertUtils;
import org.apereo.cas.util.crypto.PrivateKeyFactoryBean;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.impl.SAMLOutboundDestinationHandler;
import org.opensaml.saml.common.binding.security.impl.EndpointURLSchemeSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLOutboundProtocolMessageSigningHandler;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.saml.security.impl.SAMLMetadataSignatureSigningParametersResolver;
import org.opensaml.security.credential.AbstractCredential;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.MutableCredential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.WhitelistBlacklistConfiguration;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class SamlIdPObjectSigner {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPObjectSigner.class);
    private final MetadataResolver casSamlIdPMetadataResolver;
    private final CasConfigurationProperties casProperties;
    private final SamlIdPMetadataLocator samlIdPMetadataLocator;

    public <T extends SAMLObject> T encode(T samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletResponse response, HttpServletRequest request, String binding, RequestAbstractType authnRequest) throws SamlException {
        LOGGER.trace("Attempting to encode [{}] for [{}]", (Object)samlObject.getClass().getName(), (Object)adaptor.getEntityId());
        MessageContext outboundContext = new MessageContext();
        this.prepareOutboundContext(samlObject, adaptor, outboundContext, binding, authnRequest);
        this.prepareSecurityParametersContext(adaptor, outboundContext, service);
        this.prepareEndpointURLSchemeSecurityHandler(outboundContext);
        this.prepareSamlOutboundDestinationHandler(outboundContext);
        this.prepareSamlOutboundProtocolMessageSigningHandler(outboundContext);
        return samlObject;
    }

    protected <T extends SAMLObject> void prepareSamlOutboundProtocolMessageSigningHandler(MessageContext<T> outboundContext) throws Exception {
        LOGGER.trace("Attempting to sign the outbound SAML message...");
        SAMLOutboundProtocolMessageSigningHandler handler = new SAMLOutboundProtocolMessageSigningHandler();
        handler.setSignErrorResponses(this.casProperties.getAuthn().getSamlIdp().getResponse().isSignError());
        handler.invoke(outboundContext);
        LOGGER.debug("Signed SAML message successfully");
    }

    protected <T extends SAMLObject> void prepareSamlOutboundDestinationHandler(MessageContext<T> outboundContext) throws Exception {
        SAMLOutboundDestinationHandler handlerDest = new SAMLOutboundDestinationHandler();
        handlerDest.initialize();
        handlerDest.invoke(outboundContext);
    }

    protected <T extends SAMLObject> void prepareEndpointURLSchemeSecurityHandler(MessageContext<T> outboundContext) throws Exception {
        EndpointURLSchemeSecurityHandler handlerEnd = new EndpointURLSchemeSecurityHandler();
        handlerEnd.initialize();
        handlerEnd.invoke(outboundContext);
    }

    protected <T extends SAMLObject> void prepareSecurityParametersContext(SamlRegisteredServiceServiceProviderMetadataFacade adaptor, MessageContext<T> outboundContext, SamlRegisteredService service) {
        SecurityParametersContext secParametersContext = (SecurityParametersContext)outboundContext.getSubcontext(SecurityParametersContext.class, true);
        SPSSODescriptor roleDesc = adaptor.getSsoDescriptor();
        SignatureSigningParameters signingParameters = this.buildSignatureSigningParameters((RoleDescriptor)roleDesc, service);
        Objects.requireNonNull(secParametersContext).setSignatureSigningParameters(signingParameters);
    }

    protected <T extends SAMLObject> void prepareOutboundContext(T samlObject, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, MessageContext<T> outboundContext, String binding, RequestAbstractType authnRequest) throws SamlException {
        LOGGER.trace("Outbound saml object to use is [{}]", (Object)samlObject.getClass().getName());
        outboundContext.setMessage(samlObject);
        SamlIdPUtils.preparePeerEntitySamlEndpointContext((RequestAbstractType)authnRequest, outboundContext, (SamlRegisteredServiceServiceProviderMetadataFacade)adaptor, (String)binding);
    }

    protected SignatureSigningParameters buildSignatureSigningParameters(RoleDescriptor descriptor, SamlRegisteredService service) {
        CriteriaSet criteria = new CriteriaSet();
        SignatureSigningConfiguration signatureSigningConfiguration = this.getSignatureSigningConfiguration(descriptor, service);
        criteria.add((Object)new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{signatureSigningConfiguration}));
        criteria.add((Object)new RoleDescriptorCriterion(descriptor));
        SAMLMetadataSignatureSigningParametersResolver resolver = new SAMLMetadataSignatureSigningParametersResolver();
        LOGGER.trace("Resolving signature signing parameters for [{}]", (Object)descriptor.getElementQName().getLocalPart());
        SignatureSigningParameters params = resolver.resolveSingle(criteria);
        if (params != null) {
            LOGGER.trace("Created signature signing parameters.\nSignature algorithm: [{}]\nSignature canonicalization algorithm: [{}]\nSignature reference digest methods: [{}]\nSignature reference canonicalization algorithm: [{}]", new Object[]{params.getSignatureAlgorithm(), params.getSignatureCanonicalizationAlgorithm(), params.getSignatureReferenceDigestMethod(), params.getSignatureReferenceCanonicalizationAlgorithm()});
        } else {
            LOGGER.warn("Unable to resolve SignatureSigningParameters, response signing will fail. Make sure domain names in IDP metadata URLs and certificates match CAS domain name");
        }
        return params;
    }

    protected SignatureSigningConfiguration getSignatureSigningConfiguration(RoleDescriptor roleDescriptor, SamlRegisteredService service) throws Exception {
        BasicSignatureSigningConfiguration config = this.configureSignatureSigningSecurityConfiguration(service);
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        PrivateKey privateKey = this.getSigningPrivateKey();
        MetadataCredentialResolver kekCredentialResolver = new MetadataCredentialResolver();
        RoleDescriptorResolver roleDescriptorResolver = SamlIdPUtils.getRoleDescriptorResolver((MetadataResolver)this.casSamlIdPMetadataResolver, (boolean)samlIdp.getMetadata().isRequireValidMetadata());
        kekCredentialResolver.setRoleDescriptorResolver(roleDescriptorResolver);
        kekCredentialResolver.setKeyInfoCredentialResolver(DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
        kekCredentialResolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{config}));
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        criteriaSet.add((Object)new EntityIdCriterion(samlIdp.getEntityId()));
        criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        LinkedHashSet credentials = Sets.newLinkedHashSet((Iterable)kekCredentialResolver.resolve(criteriaSet));
        ArrayList creds = new ArrayList();
        credentials.forEach(c -> {
            AbstractCredential cred = this.getResolvedSigningCredential((Credential)c, privateKey, service);
            if (cred != null && SamlIdPObjectSigner.doesCredentialFingerprintMatch(cred, service)) {
                creds.add(cred);
            }
        });
        if (creds.isEmpty()) {
            LOGGER.error("Unable to locate any signing credentials for service [{}]", (Object)service.getName());
            throw new IllegalArgumentException("Unable to locate signing credentials");
        }
        config.setSigningCredentials(creds);
        LOGGER.trace("Signature signing credentials configured with [{}] credentials", (Object)creds.size());
        return config;
    }

    private BasicSignatureSigningConfiguration configureSignatureSigningSecurityConfiguration(SamlRegisteredService service) {
        List overrideWhiteListedAlgorithms;
        List overrideBlackListedSignatureAlgorithms;
        List overrideSignatureAlgorithms;
        List overrideSignatureReferenceDigestMethods;
        BasicSignatureSigningConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        LOGGER.trace("Default signature signing blacklisted algorithms: [{}]", (Object)config.getBlacklistedAlgorithms());
        LOGGER.trace("Default signature signing signature algorithms: [{}]", (Object)config.getSignatureAlgorithms());
        LOGGER.trace("Default signature signing signature canonicalization algorithm: [{}]", (Object)config.getSignatureCanonicalizationAlgorithm());
        LOGGER.trace("Default signature signing whitelisted algorithms: [{}]", (Object)config.getWhitelistedAlgorithms());
        LOGGER.trace("Default signature signing reference digest methods: [{}]", (Object)config.getSignatureReferenceDigestMethods());
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        SamlIdPAlgorithmsProperties globalAlgorithms = samlIdp.getAlgs();
        List list = overrideSignatureReferenceDigestMethods = service.getSigningSignatureReferenceDigestMethods().isEmpty() ? globalAlgorithms.getOverrideSignatureReferenceDigestMethods() : service.getSigningSignatureReferenceDigestMethods();
        if (overrideSignatureReferenceDigestMethods != null && !overrideSignatureReferenceDigestMethods.isEmpty()) {
            config.setSignatureReferenceDigestMethods(overrideSignatureReferenceDigestMethods);
        }
        List list2 = overrideSignatureAlgorithms = service.getSigningSignatureAlgorithms().isEmpty() ? globalAlgorithms.getOverrideSignatureAlgorithms() : service.getSigningSignatureAlgorithms();
        if (overrideSignatureAlgorithms != null && !overrideSignatureAlgorithms.isEmpty()) {
            config.setSignatureAlgorithms(overrideSignatureAlgorithms);
        }
        List list3 = overrideBlackListedSignatureAlgorithms = service.getSigningSignatureBlackListedAlgorithms().isEmpty() ? globalAlgorithms.getOverrideBlackListedSignatureSigningAlgorithms() : service.getSigningSignatureBlackListedAlgorithms();
        if (overrideBlackListedSignatureAlgorithms != null && !overrideBlackListedSignatureAlgorithms.isEmpty()) {
            config.setBlacklistedAlgorithms((Collection)overrideBlackListedSignatureAlgorithms);
        }
        List list4 = overrideWhiteListedAlgorithms = service.getSigningSignatureWhiteListedAlgorithms().isEmpty() ? globalAlgorithms.getOverrideWhiteListedSignatureSigningAlgorithms() : service.getSigningSignatureWhiteListedAlgorithms();
        if (overrideWhiteListedAlgorithms != null && !overrideWhiteListedAlgorithms.isEmpty()) {
            config.setWhitelistedAlgorithms((Collection)overrideWhiteListedAlgorithms);
        }
        if (StringUtils.isNotBlank((CharSequence)service.getSigningSignatureCanonicalizationAlgorithm())) {
            config.setSignatureCanonicalizationAlgorithm(service.getSigningSignatureCanonicalizationAlgorithm());
        } else if (StringUtils.isNotBlank((CharSequence)globalAlgorithms.getOverrideSignatureCanonicalizationAlgorithm())) {
            config.setSignatureCanonicalizationAlgorithm(globalAlgorithms.getOverrideSignatureCanonicalizationAlgorithm());
        }
        LOGGER.trace("Finalized signature signing blacklisted algorithms: [{}]", (Object)config.getBlacklistedAlgorithms());
        LOGGER.trace("Finalized signature signing signature algorithms: [{}]", (Object)config.getSignatureAlgorithms());
        LOGGER.trace("Finalized signature signing signature canonicalization algorithm: [{}]", (Object)config.getSignatureCanonicalizationAlgorithm());
        LOGGER.trace("Finalized signature signing whitelisted algorithms: [{}]", (Object)config.getWhitelistedAlgorithms());
        LOGGER.trace("Finalized signature signing reference digest methods: [{}]", (Object)config.getSignatureReferenceDigestMethods());
        if (StringUtils.isNotBlank((CharSequence)service.getWhiteListBlackListPrecedence())) {
            WhitelistBlacklistConfiguration.Precedence precedence = WhitelistBlacklistConfiguration.Precedence.valueOf((String)service.getWhiteListBlackListPrecedence().trim().toUpperCase());
            config.setWhitelistBlacklistPrecedence(precedence);
        }
        return config;
    }

    private AbstractCredential getResolvedSigningCredential(Credential c, PrivateKey privateKey, SamlRegisteredService service) {
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        try {
            SamlIdPResponseProperties.SignatureCredentialTypes credType = SamlIdPResponseProperties.SignatureCredentialTypes.valueOf((String)((String)StringUtils.defaultIfBlank((CharSequence)service.getSigningCredentialType(), (CharSequence)samlIdp.getResponse().getCredentialType().name())).toUpperCase());
            LOGGER.trace("Requested credential type [{}] is found for service [{}]", (Object)credType, (Object)service.getName());
            switch (credType) {
                case BASIC: {
                    LOGGER.debug("Building credential signing key [{}] based on requested credential type", (Object)credType);
                    if (c.getPublicKey() == null) {
                        throw new IllegalArgumentException("Unable to identify the public key from the signing credential");
                    }
                    return SamlIdPObjectSigner.finalizeSigningCredential((MutableCredential)new BasicCredential(c.getPublicKey(), privateKey), c);
                }
            }
            if (c instanceof BasicX509Credential) {
                X509Certificate certificate = ((BasicX509Credential)BasicX509Credential.class.cast(c)).getEntityCertificate();
                LOGGER.debug("Locating signature signing certificate from credential [{}]", (Object)CertUtils.toString((X509Certificate)certificate));
                return SamlIdPObjectSigner.finalizeSigningCredential((MutableCredential)new BasicX509Credential(certificate, privateKey), c);
            }
            Resource signingCert = this.samlIdPMetadataLocator.getSigningCertificate();
            LOGGER.debug("Locating signature signing certificate file from [{}]", (Object)signingCert);
            X509Certificate certificate = SamlUtils.readCertificate((Resource)signingCert);
            return SamlIdPObjectSigner.finalizeSigningCredential((MutableCredential)new BasicX509Credential(certificate, privateKey), c);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static boolean doesCredentialFingerprintMatch(AbstractCredential credential, SamlRegisteredService samlRegisteredService) {
        String fingerprint = samlRegisteredService.getSigningCredentialFingerprint();
        if (StringUtils.isNotBlank((CharSequence)fingerprint)) {
            String digest = DigestUtils.digest((String)"SHA-1", (byte[])Objects.requireNonNull(credential.getPublicKey()).getEncoded());
            Pattern pattern = RegexUtils.createPattern((String)fingerprint, (int)2);
            LOGGER.debug("Matching credential fingerprint [{}] against filter [{}] for service [{}]", new Object[]{digest, fingerprint, samlRegisteredService.getName()});
            return pattern.matcher(digest).find();
        }
        return true;
    }

    private static AbstractCredential finalizeSigningCredential(MutableCredential credential, Credential original) {
        credential.setEntityId(original.getEntityId());
        credential.setUsageType(original.getUsageType());
        Objects.requireNonNull(original.getCredentialContextSet()).forEach(ctx -> Objects.requireNonNull(credential.getCredentialContextSet()).add(ctx));
        return (AbstractCredential)credential;
    }

    protected PrivateKey getSigningPrivateKey() throws Exception {
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        Resource signingKey = this.samlIdPMetadataLocator.getSigningKey();
        PrivateKeyFactoryBean privateKeyFactoryBean = new PrivateKeyFactoryBean();
        privateKeyFactoryBean.setLocation(signingKey);
        privateKeyFactoryBean.setAlgorithm(samlIdp.getMetadata().getPrivateKeyAlgName());
        privateKeyFactoryBean.setSingleton(false);
        LOGGER.debug("Locating signature signing key from [{}]", (Object)signingKey);
        return (PrivateKey)privateKeyFactoryBean.getObject();
    }

    @Generated
    public SamlIdPObjectSigner(MetadataResolver casSamlIdPMetadataResolver, CasConfigurationProperties casProperties, SamlIdPMetadataLocator samlIdPMetadataLocator) {
        this.casSamlIdPMetadataResolver = casSamlIdPMetadataResolver;
        this.casProperties = casProperties;
        this.samlIdPMetadataLocator = samlIdPMetadataLocator;
    }
}

