/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.nameid;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.saml.attribute.encoding.impl.SAML2StringNameIDEncoder;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.apereo.cas.util.CollectionUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlNameIdBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<NameID> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlNameIdBuilder.class);
    private static final long serialVersionUID = -6231886395225437320L;
    private final PersistentIdGenerator persistentIdGenerator;
    private final transient SamlIdPObjectEncrypter samlObjectEncrypter;

    public SamlProfileSamlNameIdBuilder(OpenSamlConfigBean configBean, PersistentIdGenerator persistentIdGenerator, SamlIdPObjectEncrypter samlObjectEncrypter) {
        super(configBean);
        this.persistentIdGenerator = persistentIdGenerator;
        this.samlObjectEncrypter = samlObjectEncrypter;
    }

    protected static List<String> getSupportedNameIdFormats(SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        List supportedNameFormats = adaptor.getSupportedNameIdFormats();
        LOGGER.debug("Metadata for [{}] declares the following NameIDs [{}]", (Object)adaptor.getEntityId(), (Object)supportedNameFormats);
        if (supportedNameFormats.isEmpty()) {
            supportedNameFormats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
            LOGGER.debug("No supported nameId formats could be determined from metadata. Added default [{}]", (Object)"urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        }
        if (StringUtils.isNotBlank((CharSequence)service.getRequiredNameIdFormat())) {
            String fmt = SamlProfileSamlNameIdBuilder.parseAndBuildRequiredNameIdFormat(service);
            supportedNameFormats.add(0, fmt);
            LOGGER.debug("Added required nameId format [{}] based on saml service configuration for [{}]", (Object)fmt, (Object)service.getServiceId());
        }
        return supportedNameFormats;
    }

    private static String parseAndBuildRequiredNameIdFormat(SamlRegisteredService service) {
        String fmt = service.getRequiredNameIdFormat().trim();
        LOGGER.debug("Required NameID format assigned to service [{}] is [{}]", (Object)service.getName(), (Object)fmt);
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:transient", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:transient";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:entity", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:entity";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted";
        }
        return fmt;
    }

    @Override
    public NameID build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        return this.buildNameId(authnRequest, assertion, service, adaptor, messageContext);
    }

    private NameID buildNameId(RequestAbstractType authnRequest, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, MessageContext messageContext) throws SamlException {
        List<String> supportedNameFormats = SamlProfileSamlNameIdBuilder.getSupportedNameIdFormats(service, adaptor);
        String requiredNameFormat = SamlProfileSamlNameIdBuilder.getRequiredNameIdFormatIfAny(authnRequest);
        this.validateRequiredNameIdFormatIfAny(authnRequest, adaptor, supportedNameFormats, requiredNameFormat);
        NameID nameid = this.determineNameId(authnRequest, assertion, supportedNameFormats, service, adaptor);
        return this.finalizeNameId(nameid, authnRequest, assertion, supportedNameFormats, service, adaptor);
    }

    protected NameID finalizeNameId(NameID nameid, RequestAbstractType authnRequest, Object assertion, List<String> supportedNameFormats, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        if (StringUtils.isNotBlank((CharSequence)service.getNameIdQualifier())) {
            nameid.setNameQualifier(service.getNameIdQualifier());
        } else {
            String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
            nameid.setNameQualifier(issuer);
        }
        if (StringUtils.isNotBlank((CharSequence)service.getServiceProviderNameIdQualifier())) {
            nameid.setSPNameQualifier(service.getServiceProviderNameIdQualifier());
        } else {
            nameid.setSPNameQualifier(adaptor.getEntityId());
        }
        return nameid;
    }

    protected void validateRequiredNameIdFormatIfAny(RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, List<String> supportedNameFormats, String requiredNameFormat) {
        if (StringUtils.isNotBlank((CharSequence)requiredNameFormat) && !supportedNameFormats.contains(requiredNameFormat)) {
            LOGGER.warn("Required NameID format [{}] in the AuthN request issued by [{}] is not supported based on the metadata for [{}]. The requested NameID format may not be honored. You should consult the metadata for this service and ensure the requested NameID format is present in the collection of supported metadata formats in the metadata, which are the following: [{}]", new Object[]{requiredNameFormat, SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest), adaptor.getEntityId(), adaptor.getSupportedNameIdFormats()});
        }
    }

    protected static String getRequiredNameIdFormatIfAny(RequestAbstractType authnRequest) {
        NameIDPolicy nameIDPolicy = SamlProfileSamlNameIdBuilder.getNameIDPolicy(authnRequest);
        String requiredNameFormat = Optional.ofNullable(nameIDPolicy).map(NameIDPolicy::getFormat).orElse(null);
        LOGGER.debug("AuthN request indicates [{}] is the required NameID format", (Object)requiredNameFormat);
        return requiredNameFormat;
    }

    private static NameIDPolicy getNameIDPolicy(RequestAbstractType authnRequest) {
        if (authnRequest instanceof AuthnRequest) {
            return ((AuthnRequest)AuthnRequest.class.cast(authnRequest)).getNameIDPolicy();
        }
        return null;
    }

    protected NameID determineNameId(RequestAbstractType authnRequest, Object assertion, List<String> supportedNameFormats, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        for (String nameFormat : supportedNameFormats) {
            LOGGER.debug("Evaluating NameID format [{}]", (Object)nameFormat);
            NameID nameid = this.encodeNameIdBasedOnNameFormat(authnRequest, assertion, nameFormat, service, adaptor);
            if (nameid == null) continue;
            LOGGER.debug("Determined NameID based on format [{}] to be [{}]", (Object)nameFormat, (Object)nameid.getValue());
            return nameid;
        }
        LOGGER.warn("No NameID could be determined based on the supported formats [{}]", supportedNameFormats);
        return null;
    }

    protected NameID encodeNameIdBasedOnNameFormat(RequestAbstractType authnRequest, Object assertion, String nameFormat, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        try {
            if (authnRequest instanceof AttributeQuery) {
                AttributeQuery query = (AttributeQuery)AttributeQuery.class.cast(authnRequest);
                NameID nameID = query.getSubject().getNameID();
                nameID.detach();
                LOGGER.debug("Choosing NameID format [{}] with value [{}] for attribute query", (Object)nameID.getFormat(), (Object)nameID.getValue());
                return nameID;
            }
            IdPAttribute attribute = this.prepareNameIdAttribute(assertion, nameFormat, adaptor, service);
            SAML2StringNameIDEncoder encoder = SamlProfileSamlNameIdBuilder.prepareNameIdEncoder(authnRequest, nameFormat, attribute, service, adaptor);
            LOGGER.debug("Encoding NameID based on [{}]", (Object)nameFormat);
            NameID nameId = encoder.encode(attribute);
            LOGGER.debug("Final NameID encoded with format [{}] has value [{}]", (Object)nameId.getFormat(), (Object)nameId.getValue());
            return nameId;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected IdPAttribute prepareNameIdAttribute(Object casAssertion, String nameFormat, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService registeredService) {
        Assertion assertion = (Assertion)Assertion.class.cast(casAssertion);
        IdPAttribute attribute = new IdPAttribute(AttributePrincipal.class.getName());
        String principalName = assertion.getPrincipal().getName();
        LOGGER.debug("Preparing NameID attribute for principal [{}]", (Object)principalName);
        String nameIdValue = this.getNameIdValueFromNameFormat(nameFormat, adaptor, principalName, registeredService);
        StringAttributeValue value = new StringAttributeValue(nameIdValue);
        LOGGER.debug("NameID attribute value is set to [{}]", (Object)value);
        attribute.setValues((Collection)CollectionUtils.wrap((Object)value));
        return attribute;
    }

    private String getNameIdValueFromNameFormat(String nameFormat, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String principalName, SamlRegisteredService registeredService) {
        if (nameFormat.trim().equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:nameid-format:transient")) {
            String entityId = adaptor.getEntityId();
            if (registeredService.isSkipGeneratingTransientNameId()) {
                LOGGER.debug("Generation of transient NameID value is skipped for [{}] and [{}] will be used instead", (Object)entityId, (Object)principalName);
            } else {
                LOGGER.debug("Generating transient NameID value for principal [{}] and entity id [{}]", (Object)principalName, (Object)entityId);
                return this.persistentIdGenerator.generate(principalName, entityId);
            }
        }
        return principalName;
    }

    protected static SAML2StringNameIDEncoder prepareNameIdEncoder(RequestAbstractType authnRequest, String nameFormat, IdPAttribute attribute, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        SAML2StringNameIDEncoder encoder = new SAML2StringNameIDEncoder();
        encoder.setNameFormat(nameFormat);
        if (SamlProfileSamlNameIdBuilder.getNameIDPolicy(authnRequest) != null) {
            String qualifier = SamlProfileSamlNameIdBuilder.getNameIDPolicy(authnRequest).getSPNameQualifier();
            LOGGER.debug("NameID qualifier is set to [{}]", (Object)qualifier);
            encoder.setNameQualifier(qualifier);
        }
        return encoder;
    }
}

