/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.response;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSamlResponseBuilderConfigurationContext;
import org.apereo.inspektr.audit.annotation.Audit;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.ScratchContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSamlProfileSamlResponseBuilder<T extends XMLObject>
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSamlProfileSamlResponseBuilder.class);
    private static final long serialVersionUID = -1891703354216174875L;
    private final transient SamlProfileSamlResponseBuilderConfigurationContext samlResponseBuilderConfigurationContext;

    public BaseSamlProfileSamlResponseBuilder(SamlProfileSamlResponseBuilderConfigurationContext samlResponseBuilderConfigurationContext) {
        super(samlResponseBuilderConfigurationContext.getOpenSamlConfigBean());
        this.samlResponseBuilderConfigurationContext = samlResponseBuilderConfigurationContext;
    }

    @Override
    @Audit(action="SAML2_RESPONSE", actionResolverName="SAML2_RESPONSE_ACTION_RESOLVER", resourceResolverName="SAML2_RESPONSE_RESOURCE_RESOLVER")
    public T build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object casAssertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        Assertion assertion = this.buildSamlAssertion(authnRequest, request, response, casAssertion, service, adaptor, binding, messageContext);
        T finalResponse = this.buildResponse(assertion, casAssertion, authnRequest, service, adaptor, request, response, binding, messageContext);
        return this.encodeFinalResponse(request, response, service, adaptor, finalResponse, binding, authnRequest, casAssertion, messageContext);
    }

    protected T encodeFinalResponse(HttpServletRequest request, HttpServletResponse response, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, T finalResponse, String binding, RequestAbstractType authnRequest, Object assertion, MessageContext messageContext) {
        ScratchContext scratch = (ScratchContext)messageContext.getSubcontext(ScratchContext.class, true);
        Boolean encodeResponse = scratch.getMap().getOrDefault("encodeSamlResponse", Boolean.TRUE);
        if (encodeResponse.booleanValue()) {
            String relayState = request != null ? request.getParameter("RelayState") : "";
            LOGGER.trace("RelayState is [{}]", (Object)relayState);
            return this.encode(service, finalResponse, response, request, adaptor, relayState, binding, authnRequest, assertion);
        }
        return finalResponse;
    }

    protected Assertion buildSamlAssertion(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object casAssertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) {
        return this.samlResponseBuilderConfigurationContext.getSamlProfileSamlAssertionBuilder().build(authnRequest, request, response, casAssertion, service, adaptor, binding, messageContext);
    }

    protected abstract T buildResponse(Assertion var1, Object var2, RequestAbstractType var3, SamlRegisteredService var4, SamlRegisteredServiceServiceProviderMetadataFacade var5, HttpServletRequest var6, HttpServletResponse var7, String var8, MessageContext var9) throws SamlException;

    protected Issuer buildSamlResponseIssuer(String entityId) {
        Issuer issuer = this.newIssuer(entityId);
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        return issuer;
    }

    protected abstract T encode(SamlRegisteredService var1, T var2, HttpServletResponse var3, HttpServletRequest var4, SamlRegisteredServiceServiceProviderMetadataFacade var5, String var6, String var7, RequestAbstractType var8, Object var9) throws SamlException;

    protected SAMLObject encryptAssertion(Assertion assertion, HttpServletRequest request, HttpServletResponse response, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) throws SamlException {
        if (service.isEncryptAssertions()) {
            LOGGER.debug("SAML service [{}] requires assertions to be encrypted", (Object)adaptor.getEntityId());
            EncryptedAssertion encrypted = this.samlResponseBuilderConfigurationContext.getSamlObjectEncrypter().encode(assertion, service, adaptor);
            if (encrypted == null) {
                LOGGER.debug("SAML registered service [{}] is unable to encrypt assertions", (Object)adaptor.getEntityId());
                return assertion;
            }
            return encrypted;
        }
        LOGGER.debug("SAML registered service [{}] does not require assertions to be encrypted", (Object)adaptor.getEntityId());
        return assertion;
    }

    @Generated
    public SamlProfileSamlResponseBuilderConfigurationContext getSamlResponseBuilderConfigurationContext() {
        return this.samlResponseBuilderConfigurationContext;
    }
}

