/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.subject;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlSubjectBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<Subject> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlSubjectBuilder.class);
    private static final long serialVersionUID = 4782621942035583007L;
    private final transient SamlProfileObjectBuilder<NameID> ssoPostProfileSamlNameIdBuilder;
    private final CasConfigurationProperties casProperties;
    private final transient SamlIdPObjectEncrypter samlObjectEncrypter;

    public SamlProfileSamlSubjectBuilder(OpenSamlConfigBean configBean, SamlProfileObjectBuilder<NameID> ssoPostProfileSamlNameIdBuilder, CasConfigurationProperties casProperties, SamlIdPObjectEncrypter samlObjectEncrypter) {
        super(configBean);
        this.ssoPostProfileSamlNameIdBuilder = ssoPostProfileSamlNameIdBuilder;
        this.samlObjectEncrypter = samlObjectEncrypter;
        this.casProperties = casProperties;
    }

    @Override
    public Subject build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        return this.buildSubject(request, response, authnRequest, assertion, service, adaptor, binding, messageContext);
    }

    private Subject buildSubject(HttpServletRequest request, HttpServletResponse response, RequestAbstractType authnRequest, Object casAssertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        NameID subjectConfNameId;
        String location;
        Assertion assertion = (Assertion)Assertion.class.cast(casAssertion);
        ZonedDateTime validFromDate = ZonedDateTime.ofInstant(assertion.getValidFromDate().toInstant(), ZoneOffset.UTC);
        LOGGER.debug("Locating the assertion consumer service url for binding [{}]", (Object)binding);
        Endpoint acs = SamlIdPUtils.determineEndpointForRequest((RequestAbstractType)authnRequest, (SamlRegisteredServiceServiceProviderMetadataFacade)adaptor, (String)binding);
        String string = location = StringUtils.isBlank((CharSequence)acs.getResponseLocation()) ? acs.getLocation() : acs.getResponseLocation();
        if (StringUtils.isBlank((CharSequence)location)) {
            LOGGER.warn("Subject recipient is not defined from either authentication request or metadata for [{}]", (Object)adaptor.getEntityId());
        }
        NameID subjectNameId = this.getNameIdForService(request, response, authnRequest, service, adaptor, binding, assertion, messageContext);
        NameID nameID = subjectConfNameId = service.isSkipGeneratingSubjectConfirmationNameId() ? null : this.getNameIdForService(request, response, authnRequest, service, adaptor, binding, assertion, messageContext);
        ZonedDateTime notOnOrAfter = service.isSkipGeneratingSubjectConfirmationNotOnOrAfter() ? null : validFromDate.plusSeconds(service.getSkewAllowance() > 0 ? (long)service.getSkewAllowance() : (long)this.casProperties.getAuthn().getSamlIdp().getResponse().getSkewAllowance());
        Subject subject = this.newSubject(subjectNameId, subjectConfNameId, service.isSkipGeneratingSubjectConfirmationRecipient() ? null : location, notOnOrAfter, service.isSkipGeneratingSubjectConfirmationInResponseTo() ? null : authnRequest.getID(), service.isSkipGeneratingSubjectConfirmationNotBefore() ? null : ZonedDateTime.now(ZoneOffset.UTC));
        if ("urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted".equalsIgnoreCase(Objects.requireNonNull(subjectNameId).getFormat())) {
            subject.setNameID(null);
            subject.getSubjectConfirmations().forEach(c -> c.setNameID(null));
            EncryptedID encryptedId = this.samlObjectEncrypter.encode(subjectNameId, service, adaptor);
            if (encryptedId != null) {
                subject.setEncryptedID(encryptedId);
            } else {
                LOGGER.debug("Unable to encrypt subject Name ID for [{}]", (Object)adaptor.getEntityId());
            }
            if (subjectConfNameId != null) {
                EncryptedID encryptedConfId = this.samlObjectEncrypter.encode(subjectConfNameId, service, adaptor);
                if (encryptedConfId != null) {
                    subject.getSubjectConfirmations().forEach(c -> c.setEncryptedID(encryptedConfId));
                } else {
                    LOGGER.debug("Unable to encrypt subject confirmation Name ID for [{}]", (Object)adaptor.getEntityId());
                }
            }
        }
        LOGGER.debug("Created SAML subject [{}]", (Object)subject);
        return subject;
    }

    private NameID getNameIdForService(HttpServletRequest request, HttpServletResponse response, RequestAbstractType authnRequest, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, Assertion assertion, MessageContext messageContext) {
        if (service.isSkipGeneratingAssertionNameId()) {
            LOGGER.warn("Assertion will skip assigning/generating a nameId based on service [{}]", (Object)service);
            return null;
        }
        return this.ssoPostProfileSamlNameIdBuilder.build(authnRequest, request, response, assertion, service, adaptor, binding, messageContext);
    }
}

