/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.ecp;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;

public class ECPProfileHandlerController
extends AbstractSamlProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ECPProfileHandlerController.class);

    public ECPProfileHandlerController(SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext) {
        super(samlProfileHandlerConfigurationContext);
    }

    @PostMapping(path={"/idp/profile/SAML2/SOAP/ECP"}, consumes={"text/xml", "application/vnd.paos+xml"}, produces={"text/xml", "application/vnd.paos+xml"})
    public void handleEcpRequest(HttpServletResponse response, HttpServletRequest request) {
        MessageContext soapContext = this.decodeSoapRequest(request);
        Credential credential = ECPProfileHandlerController.extractBasicAuthenticationCredential(request, response);
        if (credential == null) {
            LOGGER.error("Credentials could not be extracted from the SAML ECP request");
            return;
        }
        if (soapContext == null) {
            LOGGER.error("SAML ECP request could not be determined from the authentication request");
            return;
        }
        this.handleEcpRequest(response, request, soapContext, credential, "urn:oasis:names:tc:SAML:2.0:bindings:PAOS");
    }

    protected void handleEcpRequest(HttpServletResponse response, HttpServletRequest request, MessageContext soapContext, Credential credential, String binding) {
        LOGGER.debug("Handling ECP request for SOAP context [{}]", (Object)soapContext);
        Envelope envelope = ((SOAP11Context)soapContext.getSubcontext(SOAP11Context.class)).getEnvelope();
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.getSamlProfileHandlerConfigurationContext().getOpenSamlConfigBean(), (XMLObject)envelope);
        AuthnRequest authnRequest = (AuthnRequest)soapContext.getMessage();
        Pair authenticationContext = Pair.of((Object)authnRequest, (Object)soapContext);
        try {
            LOGGER.trace("Verifying ECP authentication request [{}]", (Object)authnRequest);
            Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> serviceRequest = this.verifySamlAuthenticationRequest((Pair<? extends SignableSAMLObject, MessageContext>)authenticationContext, request);
            LOGGER.trace("Attempting to authenticate ECP request for credential id [{}]", (Object)credential.getId());
            Authentication authentication = this.authenticateEcpRequest(credential, (Pair<AuthnRequest, MessageContext>)authenticationContext);
            LOGGER.debug("Authenticated [{}] successfully with authenticated principal [{}]", (Object)credential.getId(), (Object)authentication.getPrincipal());
            LOGGER.trace("Building ECP SAML response for [{}]", (Object)credential.getId());
            String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
            WebApplicationService service = (WebApplicationService)this.getSamlProfileHandlerConfigurationContext().getWebApplicationServiceFactory().createService(issuer);
            Assertion casAssertion = this.buildCasAssertion(authentication, (Service)service, (RegisteredService)serviceRequest.getKey(), new LinkedHashMap<String, List<Object>>());
            LOGGER.trace("CAS assertion to use for building ECP SAML response is [{}]", (Object)casAssertion);
            this.buildSamlResponse(response, request, (Pair<AuthnRequest, MessageContext>)authenticationContext, casAssertion, binding);
        }
        catch (AuthenticationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            String error = e.getHandlerErrors().values().stream().map(Throwable::getMessage).filter(Objects::nonNull).collect(Collectors.joining(","));
            this.buildEcpFaultResponse(response, request, (Pair<RequestAbstractType, String>)Pair.of((Object)authnRequest, (Object)error));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.buildEcpFaultResponse(response, request, (Pair<RequestAbstractType, String>)Pair.of((Object)authnRequest, (Object)e.getMessage()));
        }
    }

    protected void buildEcpFaultResponse(HttpServletResponse response, HttpServletRequest request, Pair<RequestAbstractType, String> authenticationContext) {
        request.setAttribute("samlError", authenticationContext.getValue());
        this.getSamlProfileHandlerConfigurationContext().getSamlFaultResponseBuilder().build((RequestAbstractType)authenticationContext.getKey(), request, response, null, null, null, "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", null);
    }

    protected Authentication authenticateEcpRequest(Credential credential, Pair<AuthnRequest, MessageContext> authnRequest) {
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)((SAMLObject)authnRequest.getKey()));
        LOGGER.debug("Located issuer [{}] from request prior to authenticating [{}]", (Object)issuer, (Object)credential.getId());
        WebApplicationService service = (WebApplicationService)this.getSamlProfileHandlerConfigurationContext().getWebApplicationServiceFactory().createService(issuer);
        LOGGER.debug("Executing authentication request for service [{}] on behalf of credential id [{}]", (Object)service, (Object)credential.getId());
        AuthenticationResult authenticationResult = this.getSamlProfileHandlerConfigurationContext().getAuthenticationSystemSupport().handleAndFinalizeSingleAuthenticationTransaction((Service)service, new Credential[]{credential});
        return authenticationResult.getAuthentication();
    }

    private static Credential extractBasicAuthenticationCredential(HttpServletRequest request, HttpServletResponse response) {
        try {
            BasicAuthExtractor extractor = new BasicAuthExtractor();
            JEEContext webContext = new JEEContext(request, response, (SessionStore)new JEESessionStore());
            Optional credentialsResult = extractor.extract((WebContext)webContext);
            if (credentialsResult.isPresent()) {
                UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)credentialsResult.get();
                LOGGER.debug("Received basic authentication ECP request from credentials [{}]", (Object)credentials);
                return new UsernamePasswordCredential(credentials.getUsername(), credentials.getPassword());
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

