/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.query;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;

public class Saml2AttributeQueryProfileHandlerController
extends AbstractSamlProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Saml2AttributeQueryProfileHandlerController.class);

    public Saml2AttributeQueryProfileHandlerController(SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext) {
        super(samlProfileHandlerConfigurationContext);
    }

    @PostMapping(path={"/idp/profile/SAML2/SOAP/AttributeQuery"})
    protected void handlePostRequest(HttpServletResponse response, HttpServletRequest request) {
        MessageContext ctx = this.decodeSoapRequest(request);
        AttributeQuery query = (AttributeQuery)ctx.getMessage();
        try {
            String issuer = query.getIssuer().getValue();
            SamlRegisteredService service = this.verifySamlRegisteredService(issuer);
            Optional<SamlRegisteredServiceServiceProviderMetadataFacade> adaptor = this.getSamlMetadataFacadeFor(service, (RequestAbstractType)query);
            if (adaptor.isEmpty()) {
                throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
            }
            SamlRegisteredServiceServiceProviderMetadataFacade facade = adaptor.get();
            this.verifyAuthenticationContextSignature(ctx, request, (RequestAbstractType)query, facade);
            LinkedHashMap<String, Object> attrs = new LinkedHashMap<String, Object>();
            if (query.getAttributes().isEmpty()) {
                String id = this.getSamlProfileHandlerConfigurationContext().getSamlAttributeQueryTicketFactory().createTicketIdFor(query.getSubject().getNameID().getValue());
                SamlAttributeQueryTicket ticket = (SamlAttributeQueryTicket)this.getSamlProfileHandlerConfigurationContext().getTicketRegistry().getTicket(id, SamlAttributeQueryTicket.class);
                Authentication authentication = ticket.getTicketGrantingTicket().getAuthentication();
                Principal principal = authentication.getPrincipal();
                Map authnAttrs = authentication.getAttributes();
                Map principalAttrs = principal.getAttributes();
                query.getAttributes().forEach(a -> {
                    if (authnAttrs.containsKey(a.getName())) {
                        attrs.put(a.getName(), authnAttrs.get(a.getName()));
                    } else if (principalAttrs.containsKey(a.getName())) {
                        attrs.put(a.getName(), principalAttrs.get(a.getName()));
                    }
                });
            }
            Assertion casAssertion = this.buildCasAssertion(issuer, (RegisteredService)service, attrs);
            this.getSamlProfileHandlerConfigurationContext().getResponseBuilder().build((RequestAbstractType)query, request, response, casAssertion, service, facade, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", ctx);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            request.setAttribute("samlError", (Object)e.getMessage());
            this.getSamlProfileHandlerConfigurationContext().getSamlFaultResponseBuilder().build((RequestAbstractType)query, request, response, null, null, null, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", ctx);
        }
    }
}

