/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.slo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPLogoutProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSamlSLOProfileHandlerController
extends AbstractSamlProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSamlSLOProfileHandlerController.class);

    public AbstractSamlSLOProfileHandlerController(SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext) {
        super(samlProfileHandlerConfigurationContext);
    }

    protected void handleSloProfileRequest(HttpServletResponse response, HttpServletRequest request, BaseHttpServletRequestXMLMessageDecoder decoder) throws Exception {
        SamlIdPLogoutProperties logout = this.getSamlProfileHandlerConfigurationContext().getCasProperties().getAuthn().getSamlIdp().getLogout();
        if (logout.isSingleLogoutCallbacksDisabled()) {
            LOGGER.info("Processing SAML2 IdP SLO requests is disabled");
            return;
        }
        Pair<? extends SignableSAMLObject, MessageContext> pair = this.getSamlProfileHandlerConfigurationContext().getSamlHttpRequestExtractor().extract(request, decoder, LogoutRequest.class);
        LogoutRequest logoutRequest = (LogoutRequest)pair.getKey();
        MessageContext ctx = (MessageContext)pair.getValue();
        if (logout.isForceSignedLogoutRequests() && !SAMLBindingSupport.isMessageSigned((MessageContext)ctx)) {
            throw new SAMLException("Logout request is not signed but should be.");
        }
        if (SAMLBindingSupport.isMessageSigned((MessageContext)ctx)) {
            String entityId = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)logoutRequest);
            LOGGER.trace("SAML logout request from entity id [{}] is signed", (Object)entityId);
            SamlRegisteredService registeredService = (SamlRegisteredService)this.getSamlProfileHandlerConfigurationContext().getServicesManager().findServiceBy(entityId, SamlRegisteredService.class);
            LOGGER.trace("SAML registered service tied to [{}] is [{}]", (Object)entityId, (Object)registeredService);
            SamlRegisteredServiceServiceProviderMetadataFacade facade = (SamlRegisteredServiceServiceProviderMetadataFacade)SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.getSamlProfileHandlerConfigurationContext().getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (String)entityId).get();
            LOGGER.trace("Verifying signature on the SAML logout request for [{}]", (Object)entityId);
            this.getSamlProfileHandlerConfigurationContext().getSamlObjectSignatureValidator().verifySamlProfileRequestIfNeeded((RequestAbstractType)logoutRequest, facade, request, ctx);
        }
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.getSamlProfileHandlerConfigurationContext().getOpenSamlConfigBean(), (XMLObject)logoutRequest);
        response.sendRedirect(this.getSamlProfileHandlerConfigurationContext().getCasProperties().getServer().getLogoutUrl());
    }
}

