/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.slo;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.slo.DefaultSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutUrl;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.UrlValidator;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlIdPSingleLogoutServiceLogoutUrlBuilder
extends DefaultSingleLogoutServiceLogoutUrlBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPSingleLogoutServiceLogoutUrlBuilder.class);
    public static final String PROPERTY_NAME_SINGLE_LOGOUT_BINDING = "singleLogoutSamlBinding";
    protected final ServicesManager servicesManager;
    protected final SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver;

    public SamlIdPSingleLogoutServiceLogoutUrlBuilder(ServicesManager servicesManager, SamlRegisteredServiceCachingMetadataResolver resolver, UrlValidator urlValidator) {
        super(urlValidator);
        this.servicesManager = servicesManager;
        this.samlRegisteredServiceCachingMetadataResolver = resolver;
    }

    public Collection<SingleLogoutUrl> determineLogoutUrl(RegisteredService registeredService, WebApplicationService singleLogoutService) {
        try {
            SingleLogoutUrl location;
            if (registeredService instanceof SamlRegisteredService && (location = this.buildLogoutUrl(registeredService, singleLogoutService)) != null) {
                LOGGER.debug("Final logout URL built for [{}] is [{}]", (Object)registeredService, (Object)location);
                return CollectionUtils.wrap((Object)location);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        LOGGER.debug("Service [{}] is not a SAML service, or its logout url could not be determined", (Object)registeredService);
        return super.determineLogoutUrl(registeredService, singleLogoutService);
    }

    private SingleLogoutUrl buildLogoutUrl(RegisteredService registeredService, WebApplicationService singleLogoutService) {
        LOGGER.trace("Building logout url for SAML service [{}]", (Object)registeredService);
        String entityID = singleLogoutService.getId();
        LOGGER.trace("Located entity id [{}]", (Object)entityID);
        SamlRegisteredService samlRegisteredService = (SamlRegisteredService)registeredService;
        Optional adaptorRes = SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.samlRegisteredServiceCachingMetadataResolver, (SamlRegisteredService)samlRegisteredService, (String)entityID);
        if (adaptorRes.isEmpty()) {
            LOGGER.warn("Cannot find metadata linked to [{}]", (Object)entityID);
            return null;
        }
        SamlRegisteredServiceServiceProviderMetadataFacade adaptor = (SamlRegisteredServiceServiceProviderMetadataFacade)adaptorRes.get();
        SingleLogoutService sloService = adaptor.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        if (sloService != null) {
            return SamlIdPSingleLogoutServiceLogoutUrlBuilder.finalizeSingleLogoutUrl(sloService, samlRegisteredService);
        }
        sloService = adaptor.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        if (sloService != null) {
            return SamlIdPSingleLogoutServiceLogoutUrlBuilder.finalizeSingleLogoutUrl(sloService, samlRegisteredService);
        }
        sloService = adaptor.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        if (sloService != null) {
            return SamlIdPSingleLogoutServiceLogoutUrlBuilder.finalizeSingleLogoutUrl(sloService, samlRegisteredService);
        }
        LOGGER.warn("Cannot find SLO service in metadata for entity id [{}]", (Object)entityID);
        return null;
    }

    private static SingleLogoutUrl finalizeSingleLogoutUrl(SingleLogoutService sloService, SamlRegisteredService service) {
        String location = StringUtils.isBlank((CharSequence)sloService.getResponseLocation()) ? sloService.getLocation() : sloService.getResponseLocation();
        SingleLogoutUrl url = new SingleLogoutUrl(location, service.getLogoutType());
        url.getProperties().put(PROPERTY_NAME_SINGLE_LOGOUT_BINDING, sloService.getBinding());
        return url;
    }
}

