/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.slo;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.LogoutHttpMessage;
import org.apereo.cas.logout.slo.BaseSingleLogoutServiceMessageHandler;
import org.apereo.cas.logout.slo.SingleLogoutMessage;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutRequest;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPHttpRedirectDeflateLogoutEncoder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.http.HttpClient;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.w3c.dom.Node;

public class SamlIdPSingleLogoutServiceMessageHandler
extends BaseSingleLogoutServiceMessageHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPSingleLogoutServiceMessageHandler.class);
    protected final SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver;
    protected final VelocityEngine velocityEngineFactory;

    public SamlIdPSingleLogoutServiceMessageHandler(HttpClient httpClient, SingleLogoutMessageCreator logoutMessageBuilder, ServicesManager servicesManager, SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder, boolean asynchronous, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver, VelocityEngine velocityEngineFactory) {
        super(httpClient, logoutMessageBuilder, servicesManager, singleLogoutServiceLogoutUrlBuilder, asynchronous, authenticationRequestServiceSelectionStrategies);
        this.samlRegisteredServiceCachingMetadataResolver = samlRegisteredServiceCachingMetadataResolver;
        this.velocityEngineFactory = velocityEngineFactory;
    }

    protected boolean supportsInternal(WebApplicationService singleLogoutService, RegisteredService registeredService) {
        return registeredService instanceof SamlRegisteredService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendMessageToEndpoint(LogoutHttpMessage msg, SingleLogoutRequest request, SingleLogoutMessage logoutMessage) {
        String binding = (String)request.getProperties().get("singleLogoutSamlBinding");
        if ("urn:oasis:names:tc:SAML:2.0:bindings:SOAP".equalsIgnoreCase(binding)) {
            return super.sendMessageToEndpoint(msg, request, logoutMessage);
        }
        HttpResponse response = null;
        try {
            LogoutRequest logoutRequest = (LogoutRequest)logoutMessage.getMessage();
            LOGGER.trace("Sending logout response for binding [{}]", (Object)binding);
            if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equalsIgnoreCase(binding)) {
                SamlIdPHttpRedirectDeflateLogoutEncoder encoder = new SamlIdPHttpRedirectDeflateLogoutEncoder(msg.getUrl().toExternalForm(), logoutRequest);
                encoder.doEncode();
                String redirectUrl = encoder.getRedirectUrl();
                LOGGER.trace("Final logout redirect URL is [{}]", (Object)redirectUrl);
                response = HttpUtils.executeGet((String)redirectUrl);
            } else {
                String payload = SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)logoutRequest));
                LOGGER.trace("Logout request payload is [{}]", (Object)payload);
                String message = EncodingUtils.encodeBase64((byte[])payload.getBytes(StandardCharsets.UTF_8), (boolean)false);
                LOGGER.trace("Logout message encoded in base64 is [{}]", (Object)message);
                response = HttpUtils.executePost((String)msg.getUrl().toExternalForm(), (Map)CollectionUtils.wrap((String)"SAMLRequest", (Object)message), (Map)CollectionUtils.wrap((String)"Content-Type", (Object)msg.getContentType()));
            }
            if (response != null && response.getStatusLine().getStatusCode() == HttpStatus.OK.value()) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                LOGGER.trace("Received logout response as [{}]", (Object)result);
                boolean bl = true;
                HttpUtils.close((HttpResponse)response);
                return bl;
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        LOGGER.warn("No (successful) logout response received from the url [{}]", (Object)msg.getUrl().toExternalForm());
        return false;
    }

    @Generated
    public SamlRegisteredServiceCachingMetadataResolver getSamlRegisteredServiceCachingMetadataResolver() {
        return this.samlRegisteredServiceCachingMetadataResolver;
    }

    @Generated
    public VelocityEngine getVelocityEngineFactory() {
        return this.velocityEngineFactory;
    }
}

