/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.slo;

import java.util.Collection;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.saml.attribute.encoding.impl.SAML2StringNameIDEncoder;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.logout.slo.SingleLogoutMessage;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutRequest;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.RandomUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSingleLogoutMessageCreator
extends AbstractSaml20ObjectBuilder
implements SingleLogoutMessageCreator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSingleLogoutMessageCreator.class);
    private static final long serialVersionUID = -5895467960534493675L;
    protected final transient ServicesManager servicesManager;
    protected final transient SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver;
    protected final SamlIdPProperties samlIdPProperties;
    protected final SamlIdPObjectSigner samlObjectSigner;
    private final transient SOAPObjectBuilder<Envelope> envelopeBuilder;
    private final transient SOAPObjectBuilder<Body> bodyBuilder;

    public SamlProfileSingleLogoutMessageCreator(OpenSamlConfigBean configBean, ServicesManager servicesManager, SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver, SamlIdPProperties samlIdPProperties, SamlIdPObjectSigner samlObjectSigner) {
        super(configBean);
        this.servicesManager = servicesManager;
        this.samlRegisteredServiceCachingMetadataResolver = samlRegisteredServiceCachingMetadataResolver;
        this.samlIdPProperties = samlIdPProperties;
        this.samlObjectSigner = samlObjectSigner;
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.envelopeBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        this.bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
    }

    public SingleLogoutMessage create(SingleLogoutRequest request) {
        String id = "_" + String.valueOf(RandomUtils.nextLong());
        SamlRegisteredService samlService = (SamlRegisteredService)request.getRegisteredService();
        int skewAllowance = samlService.getSkewAllowance() > 0 ? samlService.getSkewAllowance() : this.samlIdPProperties.getResponse().getSkewAllowance();
        DateTime issueInstant = DateTime.now((DateTimeZone)DateTimeZone.UTC).plusSeconds(skewAllowance);
        SAML2StringNameIDEncoder encoder = new SAML2StringNameIDEncoder();
        encoder.setNameFormat((String)StringUtils.defaultIfBlank((CharSequence)samlService.getRequiredNameIdFormat(), (CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
        encoder.setNameQualifier(samlService.getNameIdQualifier());
        IdPAttribute attribute = new IdPAttribute(AttributePrincipal.class.getName());
        String principalName = request.getTicketGrantingTicket().getAuthentication().getPrincipal().getId();
        LOGGER.trace("Preparing NameID attribute for principal [{}]", (Object)principalName);
        attribute.setValues((Collection)CollectionUtils.wrap((Object)new StringAttributeValue(principalName)));
        NameID nameId = encoder.encode(attribute);
        LogoutRequest samlLogoutRequest = this.newLogoutRequest(id, issueInstant, request.getLogoutUrl().toExternalForm(), this.newIssuer(this.samlIdPProperties.getEntityId()), request.getTicketId(), nameId);
        String binding = (String)request.getProperties().get("singleLogoutSamlBinding");
        if (this.samlIdPProperties.getLogout().isForceSignedLogoutRequests()) {
            String serviceId = request.getService().getId();
            Optional adaptorRes = SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.samlRegisteredServiceCachingMetadataResolver, (SamlRegisteredService)samlService, (String)serviceId);
            SamlRegisteredServiceServiceProviderMetadataFacade adaptor = (SamlRegisteredServiceServiceProviderMetadataFacade)adaptorRes.orElseThrow(() -> new IllegalArgumentException("Unable to find metadata for saml service " + serviceId));
            HttpServletRequest httpRequest = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
            HttpServletResponse httpResponse = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
            this.samlObjectSigner.encode(samlLogoutRequest, samlService, adaptor, httpResponse, httpRequest, binding, (RequestAbstractType)samlLogoutRequest);
        }
        if ("urn:oasis:names:tc:SAML:2.0:bindings:SOAP".equalsIgnoreCase(binding)) {
            Envelope envelope = (Envelope)this.envelopeBuilder.buildObject();
            Body body = (Body)this.bodyBuilder.buildObject();
            envelope.setBody(body);
            body.getUnknownXMLObjects().add(samlLogoutRequest);
            return this.buildSingleLogoutMessage(samlLogoutRequest, (XMLObject)envelope);
        }
        return this.buildSingleLogoutMessage(samlLogoutRequest, (XMLObject)samlLogoutRequest);
    }

    private SingleLogoutMessage buildSingleLogoutMessage(LogoutRequest logoutRequest, XMLObject message) {
        SingleLogoutMessage.SingleLogoutMessageBuilder builder = SingleLogoutMessage.builder();
        return builder.message((Object)logoutRequest).payload(SamlUtils.transformSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (XMLObject)message).toString()).build();
    }
}

