/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.sso;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class SSOSamlPostProfileHandlerController
extends AbstractSamlProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOSamlPostProfileHandlerController.class);

    public SSOSamlPostProfileHandlerController(SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext) {
        super(samlProfileHandlerConfigurationContext);
    }

    @GetMapping(path={"/idp/profile/SAML2/Redirect/SSO"})
    public void handleSaml2ProfileSsoRedirectRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        BaseHttpServletRequestXMLMessageDecoder decoder = this.getSamlProfileHandlerConfigurationContext().getSamlMessageDecoders().getInstance(HttpMethod.GET);
        this.handleSsoPostProfileRequest(response, request, decoder);
    }

    @RequestMapping(path={"/idp/profile/SAML2/Redirect/SSO"}, method={RequestMethod.HEAD})
    public void handleSaml2ProfileSsoRedirectHeadRequest(HttpServletResponse response, HttpServletRequest request) {
        LOGGER.info("Endpoint [{}] called with HTTP HEAD returning 400 Bad Request", (Object)"/idp/profile/SAML2/Redirect/SSO");
        response.setStatus(400);
    }

    @PostMapping(path={"/idp/profile/SAML2/POST/SSO"})
    public void handleSaml2ProfileSsoPostRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        BaseHttpServletRequestXMLMessageDecoder decoder = this.getSamlProfileHandlerConfigurationContext().getSamlMessageDecoders().getInstance(HttpMethod.POST);
        this.handleSsoPostProfileRequest(response, request, decoder);
    }

    public void handleSsoPostProfileRequest(HttpServletResponse response, HttpServletRequest request, BaseHttpServletRequestXMLMessageDecoder decoder) throws Exception {
        Pair<? extends SignableSAMLObject, MessageContext> authnRequest = this.getSamlProfileHandlerConfigurationContext().getSamlHttpRequestExtractor().extract(request, decoder, AuthnRequest.class);
        this.initiateAuthenticationRequest(authnRequest, response, request);
    }
}

