/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.sso.request;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.support.saml.web.idp.profile.sso.request.SSOSamlHttpRequestExtractor;
import org.apereo.inspektr.audit.annotation.Audit;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SignableSAMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSSOSamlHttpRequestExtractor
implements SSOSamlHttpRequestExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSSOSamlHttpRequestExtractor.class);
    protected final ParserPool parserPool;

    @Override
    @Audit(action="SAML2_REQUEST", actionResolverName="SAML2_REQUEST_ACTION_RESOLVER", resourceResolverName="SAML2_REQUEST_RESOURCE_RESOLVER")
    public Pair<? extends SignableSAMLObject, MessageContext> extract(HttpServletRequest request, BaseHttpServletRequestXMLMessageDecoder decoder, Class<? extends SignableSAMLObject> clazz) {
        LOGGER.trace("Received SAML profile request [{}]", (Object)request.getRequestURI());
        decoder.setHttpServletRequest(request);
        decoder.setParserPool(this.parserPool);
        decoder.initialize();
        decoder.decode();
        MessageContext messageContext = decoder.getMessageContext();
        LOGGER.trace("Locating SAML object from message context...");
        SignableSAMLObject object = (SignableSAMLObject)messageContext.getMessage();
        if (object == null) {
            throw new ClassCastException("SAML object cannot be determined from the decoder [{}]" + decoder.getClass().getSimpleName());
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new ClassCastException("SAML object [" + object.getClass().getName() + " type does not match " + clazz);
        }
        LOGGER.debug("Decoded SAML object [{}] from http request", (Object)object.getElementQName());
        return Pair.of((Object)object, (Object)messageContext);
    }

    @Generated
    public DefaultSSOSamlHttpRequestExtractor(ParserPool parserPool) {
        this.parserPool = parserPool;
    }

    @Generated
    public ParserPool getParserPool() {
        return this.parserPool;
    }
}

