/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile;

import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPCoreProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.BrowserSessionStorage;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.WebUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPSOAP11Decoder;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public abstract class AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSamlIdPProfileHandlerController.class);
    protected final SamlProfileHandlerConfigurationContext configurationContext;

    protected static void logCasValidationAssertion(Assertion assertion) {
        LOGGER.debug("CAS Assertion Valid: [{}]", (Object)assertion.isValid());
        LOGGER.debug("CAS Assertion Principal: [{}]", (Object)assertion.getPrincipal().getName());
        LOGGER.debug("CAS Assertion authentication Date: [{}]", (Object)assertion.getAuthenticationDate());
        LOGGER.debug("CAS Assertion ValidFrom Date: [{}]", (Object)assertion.getValidFromDate());
        LOGGER.debug("CAS Assertion ValidUntil Date: [{}]", (Object)assertion.getValidUntilDate());
        LOGGER.debug("CAS Assertion Attributes: [{}]", (Object)assertion.getAttributes());
        LOGGER.debug("CAS Assertion Principal Attributes: [{}]", (Object)assertion.getPrincipal().getAttributes());
    }

    @ExceptionHandler(value={UnauthorizedServiceException.class, SamlException.class})
    public ModelAndView handleUnauthorizedServiceException(HttpServletRequest req, Exception ex) {
        return WebUtils.produceUnauthorizedErrorView((Exception)ex);
    }

    protected Optional<SamlRegisteredServiceServiceProviderMetadataFacade> getSamlMetadataFacadeFor(SamlRegisteredService registeredService, RequestAbstractType authnRequest) {
        return SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.configurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (RequestAbstractType)authnRequest);
    }

    protected Optional<SamlRegisteredServiceServiceProviderMetadataFacade> getSamlMetadataFacadeFor(SamlRegisteredService registeredService, String entityId) {
        return SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.configurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (String)entityId);
    }

    protected SamlRegisteredService verifySamlRegisteredService(String serviceId) {
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            throw new UnauthorizedServiceException("screen.service.error.message", "Could not verify/locate SAML registered service since no serviceId is provided");
        }
        WebApplicationService service = (WebApplicationService)this.configurationContext.getWebApplicationServiceFactory().createService(serviceId);
        LOGGER.debug("Checking service access in CAS service registry for [{}]", (Object)service);
        SamlRegisteredService registeredService = (SamlRegisteredService)this.configurationContext.getServicesManager().findServiceBy((Service)service, SamlRegisteredService.class);
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.warn("[{}] is not found in the registry or service access is denied.", (Object)serviceId);
            throw new UnauthorizedServiceException("screen.service.error.message");
        }
        LOGGER.debug("Located SAML service in the registry as [{}] with the metadata location of [{}]", (Object)registeredService.getServiceId(), (Object)registeredService.getMetadataLocation());
        return registeredService;
    }

    protected Assertion buildCasAssertion(Authentication authentication, Service service, RegisteredService registeredService, Map<String, List<Object>> attributesToCombine) {
        Map attributes = registeredService.getAttributeReleasePolicy().getAttributes(authentication.getPrincipal(), service, registeredService);
        String principalId = registeredService.getUsernameAttributeProvider().resolveUsername(authentication.getPrincipal(), service, registeredService);
        AttributePrincipalImpl principal = new AttributePrincipalImpl(principalId, attributes);
        LinkedHashMap<String, List<Object>> authnAttrs = new LinkedHashMap<String, List<Object>>(authentication.getAttributes());
        authnAttrs.putAll(attributesToCombine);
        return new AssertionImpl((AttributePrincipal)principal, DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate()), null, DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate()), authnAttrs);
    }

    protected Assertion buildCasAssertion(String principal, RegisteredService registeredService, Map<String, Object> attributes) {
        AttributePrincipalImpl p = new AttributePrincipalImpl(principal, attributes);
        return new AssertionImpl((AttributePrincipal)p, DateTimeUtils.dateOf((ChronoZonedDateTime)ZonedDateTime.now(ZoneOffset.UTC)), null, DateTimeUtils.dateOf((ChronoZonedDateTime)ZonedDateTime.now(ZoneOffset.UTC)), attributes);
    }

    protected ModelAndView issueAuthenticationRequestRedirect(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> pair, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)pair.getLeft();
        String serviceUrl = this.constructServiceUrl(request, response, pair);
        LOGGER.debug("Created service url [{}]", (Object)DigestUtils.abbreviate((String)serviceUrl));
        CasConfigurationProperties properties = this.configurationContext.getCasProperties();
        String initialUrl = CommonUtils.constructRedirectUrl((String)properties.getServer().getLoginUrl(), (String)"service", (String)serviceUrl, (boolean)authnRequest.isForceAuthn(), (boolean)authnRequest.isPassive());
        String urlToRedirectTo = this.buildRedirectUrlByRequestedAuthnContext(initialUrl, authnRequest, request);
        LOGGER.debug("Redirecting SAML authN request to [{}]", (Object)urlToRedirectTo);
        SamlIdPCoreProperties.SessionStorageTypes type = properties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
        if (type == SamlIdPCoreProperties.SessionStorageTypes.BROWSER_SESSION_STORAGE) {
            JEEContext context = new JEEContext(request, response);
            BrowserSessionStorage sessionStorage = this.configurationContext.getSessionStore().getTrackableSession((WebContext)context).map(BrowserSessionStorage.class::cast).orElseThrow(() -> new IllegalStateException("Unable to determine trackable session for storage"));
            sessionStorage.setDestinationUrl(urlToRedirectTo);
            return new ModelAndView("storage/casSessionStorageWriteView", "sessionStorage", (Object)sessionStorage);
        }
        LOGGER.debug("Redirecting SAML authN request to [{}]", (Object)urlToRedirectTo);
        ModelAndView mv = new ModelAndView((View)new RedirectView(urlToRedirectTo));
        mv.setStatus(HttpStatus.FOUND);
        return mv;
    }

    protected Map<String, String> getAuthenticationContextMappings() {
        CasConfigurationProperties properties = this.configurationContext.getCasProperties();
        List authnContexts = properties.getAuthn().getSamlIdp().getCore().getAuthenticationContextClassMappings();
        return CollectionUtils.convertDirectedListToMap((Collection)authnContexts);
    }

    protected String buildRedirectUrlByRequestedAuthnContext(String initialUrl, AuthnRequest authnRequest, HttpServletRequest request) {
        List authenticationContextClassMappings = this.configurationContext.getCasProperties().getAuthn().getSamlIdp().getCore().getAuthenticationContextClassMappings();
        if (authnRequest.getRequestedAuthnContext() == null || authenticationContextClassMappings == null || authenticationContextClassMappings.isEmpty()) {
            return initialUrl;
        }
        Map<String, String> mappings = this.getAuthenticationContextMappings();
        Optional<AuthnContextClassRef> p = authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs().stream().filter(ref -> {
            String clazz = ref.getURI();
            return mappings.containsKey(clazz);
        }).findFirst();
        if (p.isPresent()) {
            String mappedClazz = mappings.get(p.get().getURI());
            return initialUrl + "&" + this.configurationContext.getCasProperties().getAuthn().getMfa().getTriggers().getHttp().getRequestParameter() + "=" + mappedClazz;
        }
        return initialUrl;
    }

    protected String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> pair) throws SamlException {
        String string;
        block8: {
            AuthnRequest authnRequest = (AuthnRequest)pair.getLeft();
            MessageContext messageContext = (MessageContext)pair.getRight();
            StringWriter writer = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configurationContext.getOpenSamlConfigBean(), (XMLObject)authnRequest);
            try {
                URLBuilder builder = new URLBuilder(this.configurationContext.getCallbackService().getId());
                builder.getQueryParams().add(new Pair((Object)"entityId", (Object)SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest)));
                String samlRequest = EncodingUtils.encodeBase64((byte[])writer.toString().getBytes(StandardCharsets.UTF_8));
                SessionStore sessionStore = this.configurationContext.getSessionStore();
                JEEContext context = new JEEContext(request, response);
                sessionStore.set((WebContext)context, "SAMLRequest", (Object)samlRequest);
                sessionStore.set((WebContext)context, "RelayState", (Object)SAMLBindingSupport.getRelayState((MessageContext)messageContext));
                String url = builder.buildURL();
                LOGGER.trace("Built service callback url [{}]", (Object)url);
                string = CommonUtils.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)url, (String)this.configurationContext.getCasProperties().getServer().getName(), (String)"service", (String)"ticket", (boolean)false);
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            writer.close();
        }
        return string;
    }

    protected ModelAndView initiateAuthenticationRequest(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> pair, HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.autoConfigureCookiePath(request);
        this.verifySamlAuthenticationRequest(pair, request);
        return this.issueAuthenticationRequestRedirect(pair, request, response);
    }

    protected org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> verifySamlAuthenticationRequest(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> authenticationContext, HttpServletRequest request) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)authenticationContext.getKey();
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
        LOGGER.debug("Located issuer [{}] from authentication request", (Object)issuer);
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(issuer);
        LOGGER.debug("Fetching saml metadata adaptor for [{}]", (Object)issuer);
        Optional adaptor = SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.configurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (RequestAbstractType)authnRequest);
        if (adaptor.isEmpty()) {
            LOGGER.warn("No metadata could be found for [{}]", (Object)issuer);
            throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
        }
        SamlRegisteredServiceServiceProviderMetadataFacade facade = (SamlRegisteredServiceServiceProviderMetadataFacade)adaptor.get();
        this.verifyAuthenticationContextSignature(authenticationContext, request, (RequestAbstractType)authnRequest, facade);
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.configurationContext.getOpenSamlConfigBean(), (XMLObject)authnRequest);
        return org.apache.commons.lang3.tuple.Pair.of((Object)registeredService, (Object)facade);
    }

    protected void verifyAuthenticationContextSignature(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> authenticationContext, HttpServletRequest request, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) throws Exception {
        MessageContext ctx = (MessageContext)authenticationContext.getValue();
        this.verifyAuthenticationContextSignature(ctx, request, authnRequest, adaptor);
    }

    protected void verifyAuthenticationContextSignature(MessageContext ctx, HttpServletRequest request, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) throws Exception {
        if (!SAMLBindingSupport.isMessageSigned((MessageContext)ctx)) {
            LOGGER.trace("The authentication context is not signed");
            if (adaptor.isAuthnRequestsSigned()) {
                LOGGER.error("Metadata for [{}] says authentication requests are signed, yet request is not", (Object)adaptor.getEntityId());
                throw new SAMLException("Request is not signed but should be");
            }
            LOGGER.trace("Request is not signed, so there is no need to verify its signature.");
        } else {
            LOGGER.trace("The authentication context is signed; Proceeding to validate signatures...");
            this.configurationContext.getSamlObjectSignatureValidator().verifySamlProfileRequestIfNeeded(authnRequest, adaptor, request, ctx);
        }
    }

    protected void buildSamlResponse(HttpServletResponse response, HttpServletRequest request, org.apache.commons.lang3.tuple.Pair<AuthnRequest, MessageContext> authenticationContext, Assertion casAssertion, String binding) {
        AuthnRequest authnRequest = (AuthnRequest)authenticationContext.getKey();
        org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> pair = this.getRegisteredServiceAndFacade(authnRequest);
        String entityId = ((SamlRegisteredServiceServiceProviderMetadataFacade)pair.getValue()).getEntityId();
        LOGGER.debug("Preparing SAML response for [{}]", (Object)entityId);
        this.configurationContext.getResponseBuilder().build((RequestAbstractType)authnRequest, request, response, casAssertion, (SamlRegisteredService)pair.getKey(), (SamlRegisteredServiceServiceProviderMetadataFacade)pair.getValue(), binding, (MessageContext)authenticationContext.getValue());
        LOGGER.info("Built the SAML response for [{}]", (Object)entityId);
    }

    protected org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> getRegisteredServiceAndFacade(AuthnRequest request) {
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)request);
        LOGGER.debug("Located issuer [{}] from authentication context", (Object)issuer);
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(issuer);
        LOGGER.debug("Located SAML metadata for [{}]", (Object)registeredService.getServiceId());
        Optional<SamlRegisteredServiceServiceProviderMetadataFacade> adaptor = this.getSamlMetadataFacadeFor(registeredService, (RequestAbstractType)request);
        if (adaptor.isEmpty()) {
            throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
        }
        SamlRegisteredServiceServiceProviderMetadataFacade facade = adaptor.get();
        return org.apache.commons.lang3.tuple.Pair.of((Object)registeredService, (Object)facade);
    }

    protected MessageContext decodeSoapRequest(HttpServletRequest request) {
        try {
            HTTPSOAP11Decoder decoder = new HTTPSOAP11Decoder();
            decoder.setParserPool(this.configurationContext.getOpenSamlConfigBean().getParserPool());
            decoder.setHttpServletRequest(request);
            BindingDescriptor binding = new BindingDescriptor();
            binding.setId(this.getClass().getName());
            binding.setShortName(this.getClass().getName());
            binding.setSignatureCapable(true);
            binding.setSynchronous(true);
            decoder.setBindingDescriptor(binding);
            decoder.initialize();
            decoder.decode();
            return decoder.getMessageContext();
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    protected void autoConfigureCookiePath(HttpServletRequest request) {
        CasConfigurationProperties casProperties = this.configurationContext.getCasProperties();
        SamlIdPCoreProperties.SessionStorageTypes sessionStorageType = casProperties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
        if (sessionStorageType == SamlIdPCoreProperties.SessionStorageTypes.TICKET_REGISTRY && casProperties.getSessionReplication().getCookie().isAutoConfigureCookiePath()) {
            String contextPath = request.getContextPath();
            Object cookiePath = StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath + "/" : "/";
            CasCookieBuilder cookieBuilder = this.configurationContext.getSamlDistributedSessionCookieGenerator();
            String path = cookieBuilder.getCookiePath();
            if (StringUtils.isBlank((CharSequence)path)) {
                LOGGER.debug("Setting path for cookies for SAML2 distributed session cookie generator to: [{}]", cookiePath);
                cookieBuilder.setCookiePath((String)cookiePath);
            } else {
                LOGGER.trace("SAML2 authentication cookie domain is [{}] with path [{}]", (Object)cookieBuilder.getCookieDomain(), (Object)path);
            }
        }
    }

    protected ModelAndView handleSsoPostProfileRequest(HttpServletResponse response, HttpServletRequest request, BaseHttpServletRequestXMLMessageDecoder decoder) {
        try {
            org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> result = this.getConfigurationContext().getSamlHttpRequestExtractor().extract(request, decoder, AuthnRequest.class).orElseThrow(() -> new IllegalArgumentException("Unable to extract SAML request"));
            return this.initiateAuthenticationRequest(result, response, request);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return WebUtils.produceErrorView((Exception)e);
        }
    }

    @Generated
    protected AbstractSamlIdPProfileHandlerController(SamlProfileHandlerConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public SamlProfileHandlerConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }
}

