/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;

public class SamlIdPInitiatedProfileHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPInitiatedProfileHandlerController.class);

    public SamlIdPInitiatedProfileHandlerController(SamlProfileHandlerConfigurationContext ctx) {
        super(ctx);
    }

    @GetMapping(path={"/idp/profile/SAML2/Unsolicited/SSO"})
    protected ModelAndView handleIdPInitiatedSsoRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        String providerId = request.getParameter("providerId");
        if (StringUtils.isBlank((CharSequence)providerId)) {
            LOGGER.warn("No providerId parameter given in unsolicited SSO authentication request.");
            throw new MessageDecodingException("Missing providerId");
        }
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(providerId);
        Optional<SamlRegisteredServiceServiceProviderMetadataFacade> adaptor = this.getSamlMetadataFacadeFor(registeredService, providerId);
        if (adaptor.isEmpty()) {
            throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + providerId);
        }
        String shire = request.getParameter("shire");
        SamlRegisteredServiceServiceProviderMetadataFacade facade = adaptor.get();
        if (StringUtils.isBlank((CharSequence)shire)) {
            LOGGER.warn("Resolving service provider assertion consumer service URL for [{}] and binding [{}]", (Object)providerId, (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            AssertionConsumerService acs = facade.getAssertionConsumerService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            String string = acs != null ? (StringUtils.isBlank((CharSequence)acs.getResponseLocation()) ? acs.getLocation() : acs.getResponseLocation()) : (shire = null);
        }
        if (StringUtils.isBlank((CharSequence)shire)) {
            LOGGER.warn("Unable to resolve service provider assertion consumer service URL for AuthnRequest construction for entityID: [{}]", (Object)providerId);
            throw new MessageDecodingException("Unable to resolve SP ACS URL for AuthnRequest construction");
        }
        String target = request.getParameter("target");
        String time = request.getParameter("time");
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.getConfigurationContext().getOpenSamlConfigBean().getBuilderFactory().getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest authnRequest = (AuthnRequest)builder.buildObject();
        authnRequest.setAssertionConsumerServiceURL(shire);
        SAMLObjectBuilder isBuilder = (SAMLObjectBuilder)this.getConfigurationContext().getOpenSamlConfigBean().getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)isBuilder.buildObject();
        issuer.setValue(providerId);
        authnRequest.setIssuer(issuer);
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        SAMLObjectBuilder pBuilder = (SAMLObjectBuilder)this.getConfigurationContext().getOpenSamlConfigBean().getBuilderFactory().getBuilder(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        NameIDPolicy nameIDPolicy = (NameIDPolicy)pBuilder.buildObject();
        nameIDPolicy.setAllowCreate(Boolean.TRUE);
        authnRequest.setNameIDPolicy(nameIDPolicy);
        if (NumberUtils.isCreatable((String)time)) {
            authnRequest.setIssueInstant(Instant.ofEpochMilli(Long.parseLong(time)));
        } else {
            authnRequest.setIssueInstant(ZonedDateTime.now(ZoneOffset.UTC).toInstant());
        }
        authnRequest.setForceAuthn(Boolean.FALSE);
        if (StringUtils.isNotBlank((CharSequence)target)) {
            request.setAttribute("RelayState", (Object)target);
        }
        MessageContext ctx = new MessageContext();
        if (facade.isAuthnRequestsSigned() || registeredService.isSignUnsolicitedAuthnRequest()) {
            this.getConfigurationContext().getSamlObjectSigner().encode(authnRequest, registeredService, facade, response, request, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (RequestAbstractType)authnRequest);
        }
        ctx.setMessage((Object)authnRequest);
        SAMLBindingContext bindingContext = (SAMLBindingContext)ctx.getSubcontext(SAMLBindingContext.class, true);
        Objects.requireNonNull(bindingContext).setHasBindingSignature(false);
        SAMLBindingSupport.setRelayState((MessageContext)ctx, (String)target);
        Pair pair = Pair.of((Object)authnRequest, (Object)ctx);
        return this.initiateAuthenticationRequest((Pair<? extends SignableSAMLObject, MessageContext>)pair, response, request);
    }
}

