/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.artifact;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.impl.BasicSAMLArtifactMap;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;

public class CasSamlArtifactMap
extends BasicSAMLArtifactMap {
    private final TicketRegistry ticketRegistry;
    private final SamlArtifactTicketFactory samlArtifactTicketFactory;
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    private final SessionStore samlIdPDistributedSessionStore;
    private final CentralAuthenticationService centralAuthenticationService;

    public void put(String artifact, String relyingPartyId, String issuerId, SAMLObject samlMessage) throws IOException {
        super.put(artifact, relyingPartyId, issuerId, samlMessage);
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
        TicketGrantingTicket ticketGrantingTicket = CookieUtils.getTicketGrantingTicketFromRequest((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator, (TicketRegistry)this.ticketRegistry, (HttpServletRequest)request);
        if (ticketGrantingTicket == null) {
            ticketGrantingTicket = this.samlIdPDistributedSessionStore.get((WebContext)new JEEContext(request, response), "ticketGrantingTicketId").map(ticketId -> (TicketGrantingTicket)this.centralAuthenticationService.getTicket(ticketId.toString(), TicketGrantingTicket.class)).orElse(null);
        }
        SamlArtifactTicket ticket = this.samlArtifactTicketFactory.create(artifact, Objects.requireNonNull(ticketGrantingTicket).getAuthentication(), ticketGrantingTicket, issuerId, relyingPartyId, samlMessage);
        this.ticketRegistry.addTicket((Ticket)ticket);
    }

    @Generated
    public CasSamlArtifactMap(TicketRegistry ticketRegistry, SamlArtifactTicketFactory samlArtifactTicketFactory, CasCookieBuilder ticketGrantingTicketCookieGenerator, SessionStore samlIdPDistributedSessionStore, CentralAuthenticationService centralAuthenticationService) {
        this.ticketRegistry = ticketRegistry;
        this.samlArtifactTicketFactory = samlArtifactTicketFactory;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.samlIdPDistributedSessionStore = samlIdPDistributedSessionStore;
        this.centralAuthenticationService = centralAuthenticationService;
    }
}

