/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.artifact;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.ArtifactResolve;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;

public class SamlIdPSaml1ArtifactResolutionProfileHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPSaml1ArtifactResolutionProfileHandlerController.class);

    public SamlIdPSaml1ArtifactResolutionProfileHandlerController(SamlProfileHandlerConfigurationContext ctx) {
        super(ctx);
    }

    @PostMapping(path={"/idp/profile/SAML1/SOAP/ArtifactResolution"})
    protected void handlePostRequest(HttpServletResponse response, HttpServletRequest request) {
        MessageContext ctx = this.decodeSoapRequest(request);
        ArtifactResolve artifactMsg = (ArtifactResolve)ctx.getMessage();
        SamlProfileHandlerConfigurationContext config = this.getConfigurationContext();
        try {
            String issuer = artifactMsg.getIssuer().getValue();
            SamlRegisteredService service = this.verifySamlRegisteredService(issuer);
            Optional<SamlRegisteredServiceServiceProviderMetadataFacade> adaptor = this.getSamlMetadataFacadeFor(service, (RequestAbstractType)artifactMsg);
            if (adaptor.isEmpty()) {
                throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
            }
            SamlRegisteredServiceServiceProviderMetadataFacade facade = adaptor.get();
            this.verifyAuthenticationContextSignature(ctx, request, (RequestAbstractType)artifactMsg, facade);
            String artifactId = artifactMsg.getArtifact().getValue();
            String ticketId = config.getArtifactTicketFactory().createTicketIdFor(artifactId);
            SamlArtifactTicket ticket = (SamlArtifactTicket)config.getTicketRegistry().getTicket(ticketId, SamlArtifactTicket.class);
            if (ticket == null) {
                throw new InvalidTicketException(ticketId);
            }
            WebApplicationService issuerService = (WebApplicationService)config.getWebApplicationServiceFactory().createService(issuer);
            Assertion casAssertion = this.buildCasAssertion(ticket.getTicketGrantingTicket().getAuthentication(), (Service)issuerService, (RegisteredService)service, CollectionUtils.wrap((String)"artifact", (Object)ticket));
            config.getResponseBuilder().build((RequestAbstractType)artifactMsg, request, response, casAssertion, service, facade, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", ctx);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            request.setAttribute("samlError", (Object)("Unable to build SOAP response: " + StringUtils.defaultString((String)e.getMessage())));
            config.getSamlFaultResponseBuilder().build((RequestAbstractType)artifactMsg, request, response, null, null, null, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", ctx);
        }
    }
}

