/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.attr;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.attribute.AttributeDefinition;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPResponseProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.util.Saml20AttributeBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlIdPAttributeDefinition;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlProfileSamlRegisteredServiceAttributeBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.apereo.cas.util.CollectionUtils;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SamlProfileSamlAttributeStatementBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<AttributeStatement> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlAttributeStatementBuilder.class);
    private static final long serialVersionUID = 1815697787562189088L;
    private final SamlIdPProperties samlIdPProperties;
    private final SamlIdPObjectEncrypter samlObjectEncrypter;
    private final AttributeDefinitionStore attributeDefinitionStore;
    private final ServiceFactory<WebApplicationService> serviceFactory;

    public SamlProfileSamlAttributeStatementBuilder(OpenSamlConfigBean configBean, SamlIdPProperties samlIdPProperties, SamlIdPObjectEncrypter samlObjectEncrypter, AttributeDefinitionStore attributeDefinitionStore, ServiceFactory<WebApplicationService> serviceFactory) {
        super(configBean);
        this.samlIdPProperties = samlIdPProperties;
        this.samlObjectEncrypter = samlObjectEncrypter;
        this.attributeDefinitionStore = attributeDefinitionStore;
        this.serviceFactory = serviceFactory;
    }

    @Override
    public AttributeStatement build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object casAssertion, SamlRegisteredService registeredService, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        Assertion assertion = (Assertion)Assertion.class.cast(casAssertion);
        HashMap attributes = new HashMap(assertion.getAttributes());
        attributes.putAll(assertion.getPrincipal().getAttributes());
        WebApplicationService webApplicationService = (WebApplicationService)this.serviceFactory.createService(adaptor.getEntityId(), WebApplicationService.class);
        Map encodedAttrs = ProtocolAttributeEncoder.decodeAttributes(attributes, (RegisteredService)registeredService, (WebApplicationService)webApplicationService);
        SamlProfileSamlRegisteredServiceAttributeBuilder attrBuilder = new SamlProfileSamlRegisteredServiceAttributeBuilder(registeredService, adaptor, this.samlObjectEncrypter);
        return this.newAttributeStatement(encodedAttrs, (Saml20AttributeBuilder)attrBuilder, registeredService);
    }

    public AttributeStatement newAttributeStatement(Map<String, Object> attributes, Saml20AttributeBuilder builder, SamlRegisteredService samlRegisteredService) {
        AttributeStatement attrStatement = (AttributeStatement)SamlUtils.newSamlObject(AttributeStatement.class);
        SamlIdPResponseProperties resp = this.samlIdPProperties.getResponse();
        HashMap nameFormats = new HashMap(resp.configureAttributeNameFormats());
        nameFormats.putAll(samlRegisteredService.getAttributeNameFormats());
        List globalFriendlyNames = this.samlIdPProperties.getCore().getAttributeFriendlyNames();
        HashMap friendlyNames = new HashMap(CollectionUtils.convertDirectedListToMap((Collection)globalFriendlyNames));
        HashMap urns = new HashMap();
        this.attributeDefinitionStore.getAttributeDefinitions().stream().filter(defn -> defn instanceof SamlIdPAttributeDefinition).map(SamlIdPAttributeDefinition.class::cast).forEach(defn -> {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)defn.getFriendlyName())) {
                friendlyNames.put(defn.getKey(), defn.getFriendlyName());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)defn.getUrn())) {
                urns.put(defn.getKey(), defn.getUrn());
            }
        });
        friendlyNames.putAll(samlRegisteredService.getAttributeFriendlyNames());
        for (Map.Entry<String, Object> e : attributes.entrySet()) {
            if (e.getValue() instanceof Collection && ((Collection)e.getValue()).isEmpty()) {
                LOGGER.info("Skipping attribute [{}] because it does not have any values.", (Object)e.getKey());
                continue;
            }
            String friendlyName = friendlyNames.getOrDefault(e.getKey(), null);
            Collection<String> attributeNames = urns.containsKey(e.getKey()) ? List.of((String)urns.get(e.getKey())) : this.getMappedAttributeNamesFromAttributeDefinitionStore(e);
            attributeNames.forEach(name -> {
                LOGGER.trace("Creating SAML attribute [{}] with value [{}], friendlyName [{}]", new Object[]{attributeNames, e.getValue(), friendlyName});
                Attribute attribute = this.newAttribute(friendlyName, (String)name, e.getValue(), nameFormats, resp.getDefaultAttributeNameFormat(), samlRegisteredService.getAttributeValueTypes());
                LOGGER.trace("Created SAML attribute [{}] with nameid-format [{}]", (Object)attribute.getName(), (Object)attribute.getNameFormat());
                builder.build(attrStatement, attribute);
            });
        }
        return attrStatement;
    }

    protected Collection<String> getMappedAttributeNamesFromAttributeDefinitionStore(Map.Entry<String, Object> entry) {
        return StringUtils.commaDelimitedListToSet((String)this.attributeDefinitionStore.locateAttributeDefinition(entry.getKey()).map(AttributeDefinition::getName).filter(org.apache.commons.lang3.StringUtils::isNotBlank).orElseGet(entry::getKey));
    }
}

