/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc.encoder.sso;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.encoder.BaseHttpServletAwareSamlObjectEncoder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.messaging.context.SAMLArtifactContext;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml.saml2.binding.encoding.impl.BaseSAML2MessageEncoder;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPArtifactEncoder;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;

public class SamlResponseArtifactEncoder
extends BaseHttpServletAwareSamlObjectEncoder<Response> {
    private final SAMLArtifactMap samlArtifactMap;

    public SamlResponseArtifactEncoder(VelocityEngine velocityEngineFactory, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SAMLArtifactMap samlArtifactMap) {
        super(velocityEngineFactory, adaptor, httpResponse, httpRequest);
        this.samlArtifactMap = samlArtifactMap;
    }

    @Override
    protected void finalizeEncode(RequestAbstractType authnRequest, BaseSAML2MessageEncoder e, Response samlResponse, String relayState) throws Exception {
        HTTPArtifactEncoder encoder = (HTTPArtifactEncoder)e;
        encoder.setArtifactMap(this.samlArtifactMap);
        MessageContext ctx = this.getEncoderMessageContext(authnRequest, samlResponse, relayState);
        this.prepareArtifactContext(samlResponse, ctx);
        encoder.setMessageContext(ctx);
        super.finalizeEncode(authnRequest, (BaseSAML2MessageEncoder)encoder, samlResponse, relayState);
    }

    @Override
    protected String getBinding() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    @Override
    protected BaseSAML2MessageEncoder getMessageEncoderInstance() {
        HTTPArtifactEncoder encoder = new HTTPArtifactEncoder();
        encoder.setVelocityEngine(this.velocityEngineFactory);
        return encoder;
    }

    private void prepareArtifactContext(Response samlResponse, MessageContext ctx) {
        SAMLArtifactContext art = (SAMLArtifactContext)ctx.getSubcontext(SAMLArtifactContext.class, true);
        Objects.requireNonNull(art).setArtifactType(SAML2ArtifactType0004.TYPE_CODE);
        art.setSourceEntityId(samlResponse.getIssuer().getValue());
        AssertionConsumerService svc = this.adaptor.getAssertionConsumerServiceForArtifactBinding();
        art.setSourceArtifactResolutionServiceEndpointIndex(svc.getIndex());
        art.setSourceArtifactResolutionServiceEndpointURL(svc.getLocation());
    }
}

