/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.response;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.encoder.sso.SamlResponseArtifactEncoder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.encoder.sso.SamlResponsePostEncoder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.encoder.sso.SamlResponsePostSimpleSignEncoder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.BaseSamlProfileSamlResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSamlResponseBuilderConfigurationContext;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSaml2ResponseBuilder
extends BaseSamlProfileSamlResponseBuilder<Response> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSaml2ResponseBuilder.class);
    private static final long serialVersionUID = 1488837627964481272L;

    public SamlProfileSaml2ResponseBuilder(SamlProfileSamlResponseBuilderConfigurationContext samlResponseBuilderConfigurationContext) {
        super(samlResponseBuilderConfigurationContext);
    }

    @Override
    public Response buildResponse(Assertion assertion, Object casAssertion, RequestAbstractType authnRequest, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletRequest request, HttpServletResponse response, String binding, MessageContext messageContext) throws SamlException {
        SAMLObject finalAssertion;
        String id = "_" + String.valueOf(RandomUtils.nextLong());
        Response samlResponse = this.newResponse(id, ZonedDateTime.now(ZoneOffset.UTC), authnRequest.getID(), null);
        samlResponse.setVersion(SAMLVersion.VERSION_20);
        SamlProfileSamlResponseBuilderConfigurationContext configContext = this.getSamlResponseBuilderConfigurationContext();
        if (StringUtils.isBlank((CharSequence)service.getIssuerEntityId())) {
            samlResponse.setIssuer(this.buildSamlResponseIssuer(configContext.getCasProperties().getAuthn().getSamlIdp().getCore().getEntityId()));
        } else {
            samlResponse.setIssuer(this.buildSamlResponseIssuer(service.getIssuerEntityId()));
        }
        Endpoint acs = SamlIdPUtils.determineEndpointForRequest((RequestAbstractType)authnRequest, (SamlRegisteredServiceServiceProviderMetadataFacade)adaptor, (String)binding);
        String location = StringUtils.isBlank((CharSequence)acs.getResponseLocation()) ? acs.getLocation() : acs.getResponseLocation();
        samlResponse.setDestination(location);
        if (configContext.getCasProperties().getAuthn().getSamlIdp().getCore().isAttributeQueryProfileEnabled()) {
            this.storeAttributeQueryTicketInRegistry(assertion, request, adaptor);
        }
        if ((finalAssertion = this.encryptAssertion(assertion, request, response, service, adaptor)) instanceof EncryptedAssertion) {
            LOGGER.trace("Built assertion is encrypted, so the response will add it to the encrypted assertions collection");
            samlResponse.getEncryptedAssertions().add((EncryptedAssertion)EncryptedAssertion.class.cast(finalAssertion));
        } else {
            LOGGER.trace("Built assertion is not encrypted, so the response will add it to the assertions collection");
            samlResponse.getAssertions().add((Assertion)Assertion.class.cast(finalAssertion));
        }
        Status status = this.newStatus("urn:oasis:names:tc:SAML:2.0:status:Success", null);
        samlResponse.setStatus(status);
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (XMLObject)samlResponse);
        if (service.isSignResponses()) {
            LOGGER.debug("SAML entity id [{}] indicates that SAML responses should be signed", (Object)adaptor.getEntityId());
            Response samlResponseSigned = configContext.getSamlObjectSigner().encode(samlResponse, service, adaptor, response, request, binding, authnRequest);
            SamlUtils.logSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (XMLObject)samlResponseSigned);
            return samlResponseSigned;
        }
        return samlResponse;
    }

    @Override
    protected Response encode(SamlRegisteredService service, Response samlResponse, HttpServletResponse httpResponse, HttpServletRequest httpRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String relayState, String binding, RequestAbstractType authnRequest, Object assertion) throws SamlException {
        LOGGER.trace("Constructing encoder based on binding [{}] for [{}]", (Object)binding, (Object)adaptor.getEntityId());
        SamlProfileSamlResponseBuilderConfigurationContext configContext = this.getSamlResponseBuilderConfigurationContext();
        if (binding.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact")) {
            SamlResponseArtifactEncoder encoder = new SamlResponseArtifactEncoder(configContext.getVelocityEngineFactory(), adaptor, httpRequest, httpResponse, configContext.getSamlArtifactMap());
            return encoder.encode(authnRequest, samlResponse, relayState);
        }
        if (binding.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign")) {
            SamlResponsePostSimpleSignEncoder encoder = new SamlResponsePostSimpleSignEncoder(configContext.getVelocityEngineFactory(), adaptor, httpResponse, httpRequest);
            return encoder.encode(authnRequest, samlResponse, relayState);
        }
        SamlResponsePostEncoder encoder = new SamlResponsePostEncoder(configContext.getVelocityEngineFactory(), adaptor, httpResponse, httpRequest);
        return encoder.encode(authnRequest, samlResponse, relayState);
    }

    private void storeAttributeQueryTicketInRegistry(Assertion assertion, HttpServletRequest request, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        String value = assertion.getSubject().getNameID().getValue();
        TicketGrantingTicket ticketGrantingTicket = CookieUtils.getTicketGrantingTicketFromRequest((CasCookieBuilder)this.getSamlResponseBuilderConfigurationContext().getTicketGrantingTicketCookieGenerator(), (TicketRegistry)this.getSamlResponseBuilderConfigurationContext().getTicketRegistry(), (HttpServletRequest)request);
        SamlAttributeQueryTicket ticket = this.getSamlResponseBuilderConfigurationContext().getSamlAttributeQueryTicketFactory().create(value, (SAMLObject)assertion, adaptor.getEntityId(), ticketGrantingTicket);
        this.getSamlResponseBuilderConfigurationContext().getTicketRegistry().addTicket((Ticket)ticket);
    }
}

