/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.query;

import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.apereo.cas.util.LoggingUtils;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;

public class SamlIdPSaml2AttributeQueryProfileHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPSaml2AttributeQueryProfileHandlerController.class);

    public SamlIdPSaml2AttributeQueryProfileHandlerController(SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext) {
        super(samlProfileHandlerConfigurationContext);
    }

    @PostMapping(path={"/idp/profile/SAML2/SOAP/AttributeQuery"})
    protected void handlePostRequest(HttpServletResponse response, HttpServletRequest request) {
        MessageContext ctx = this.decodeSoapRequest(request);
        AttributeQuery query = (AttributeQuery)ctx.getMessage();
        SamlProfileHandlerConfigurationContext config = this.getConfigurationContext();
        try {
            String issuer = Objects.requireNonNull(query).getIssuer().getValue();
            SamlRegisteredService service = this.verifySamlRegisteredService(issuer);
            Optional<SamlRegisteredServiceServiceProviderMetadataFacade> adaptor = this.getSamlMetadataFacadeFor(service, (RequestAbstractType)query);
            if (adaptor.isEmpty()) {
                throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
            }
            SamlRegisteredServiceServiceProviderMetadataFacade facade = adaptor.get();
            this.verifyAuthenticationContextSignature(ctx, request, (RequestAbstractType)query, facade);
            LinkedHashMap availableAttributes = new LinkedHashMap();
            LinkedHashMap<String, Object> finalAttributes = new LinkedHashMap<String, Object>();
            if (!query.getAttributes().isEmpty()) {
                String id = config.getSamlAttributeQueryTicketFactory().createTicketIdFor(query.getSubject().getNameID().getValue());
                LOGGER.debug("Created ticket id for attribute query [{}]", (Object)id);
                SamlAttributeQueryTicket ticket = (SamlAttributeQueryTicket)config.getTicketRegistry().getTicket(id, SamlAttributeQueryTicket.class);
                if (ticket == null) {
                    throw new InvalidTicketException(id);
                }
                Authentication authentication = ticket.getTicketGrantingTicket().getAuthentication();
                Principal principal = authentication.getPrincipal();
                availableAttributes.putAll(authentication.getAttributes());
                availableAttributes.putAll(principal.getAttributes());
            }
            query.getAttributes().forEach(a -> {
                if (availableAttributes.containsKey(a.getName())) {
                    finalAttributes.put(a.getName(), availableAttributes.get(a.getName()));
                }
            });
            LOGGER.trace("Final attributes for attribute query are [{}]", finalAttributes);
            Assertion casAssertion = this.buildCasAssertion(issuer, (RegisteredService)service, finalAttributes);
            config.getResponseBuilder().build((RequestAbstractType)query, request, response, casAssertion, service, facade, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", ctx);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            request.setAttribute("samlError", (Object)("Unable to build SOAP response: " + StringUtils.defaultString((String)e.getMessage())));
            config.getSamlFaultResponseBuilder().build((RequestAbstractType)query, request, response, null, null, null, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", ctx);
        }
    }
}

