/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.slo;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPLogoutProperties;
import org.apereo.cas.logout.LogoutRedirectionStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPHttpRedirectDeflateEncoder;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPLogoutResponseObjectBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.support.WebUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.ext.saml2aslo.Asynchronous;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Node;

public class SamlIdPSingleLogoutRedirectionStrategy
implements LogoutRedirectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPSingleLogoutRedirectionStrategy.class);
    private final SamlProfileHandlerConfigurationContext configurationContext;

    public int getOrder() {
        return 0;
    }

    public boolean supports(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        RegisteredService registeredService = WebUtils.getRegisteredService((HttpServletRequest)request);
        if (registeredService instanceof SamlRegisteredService) {
            SamlIdPLogoutProperties logout = this.configurationContext.getCasProperties().getAuthn().getSamlIdp().getLogout();
            SamlRegisteredService samlRegisteredService = (SamlRegisteredService)registeredService;
            String sloRequest = WebUtils.getSingleLogoutRequest((HttpServletRequest)request);
            AtomicBoolean async = new AtomicBoolean(false);
            if (StringUtils.isNotBlank((CharSequence)sloRequest)) {
                async.set(this.getLogoutRequest(request).map(RequestAbstractType::getExtensions).stream().filter(Objects::nonNull).anyMatch(extensions -> !extensions.getUnknownXMLObjects(Asynchronous.DEFAULT_ELEMENT_NAME).isEmpty()));
            }
            return logout.isSendLogoutResponse() && samlRegisteredService != null && samlRegisteredService.isLogoutResponseEnabled() && sloRequest != null && !async.get();
        }
        return false;
    }

    public void handle(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        SamlRegisteredService samlRegisteredService = (SamlRegisteredService)WebUtils.getRegisteredService((HttpServletRequest)request);
        LogoutRequest samlLogoutRequest = this.getLogoutRequest(request).get();
        String logoutRequestIssuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)samlLogoutRequest);
        Optional adaptorRes = SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.configurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)samlRegisteredService, (String)logoutRequestIssuer);
        if (adaptorRes.isEmpty()) {
            LOGGER.warn("Cannot find service provider metadata entity linked to [{}]", (Object)logoutRequestIssuer);
        } else {
            SamlRegisteredServiceServiceProviderMetadataFacade adaptor = (SamlRegisteredServiceServiceProviderMetadataFacade)adaptorRes.get();
            String binding = this.determineLogoutResponseBindingType(samlRegisteredService);
            LOGGER.debug("Logout response binding type is determined as [{}]", (Object)binding);
            switch (StringUtils.defaultString((String)binding)) {
                case "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST": {
                    this.handleSingleLogoutForPostBinding(context, samlLogoutRequest, samlRegisteredService, adaptor);
                    break;
                }
                case "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect": {
                    this.handleSingleLogoutForRedirectBinding(context, samlLogoutRequest, samlRegisteredService, adaptor);
                    break;
                }
                default: {
                    this.handleSingleLogoutForPostBinding(context, samlLogoutRequest, samlRegisteredService, adaptor);
                    this.handleSingleLogoutForRedirectBinding(context, samlLogoutRequest, samlRegisteredService, adaptor);
                }
            }
        }
    }

    protected String determineLogoutResponseBindingType(SamlRegisteredService samlRegisteredService) {
        SamlIdPLogoutProperties logout = this.configurationContext.getCasProperties().getAuthn().getSamlIdp().getLogout();
        return (String)StringUtils.defaultIfBlank((CharSequence)samlRegisteredService.getLogoutResponseBinding(), (CharSequence)logout.getLogoutResponseBinding());
    }

    protected void handleSingleLogoutForRedirectBinding(RequestContext context, LogoutRequest samlLogoutRequest, SamlRegisteredService samlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        SingleLogoutService sloService = adaptor.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        if (sloService != null) {
            this.produceSamlLogoutResponseRedirect(adaptor, sloService, context, samlRegisteredService, samlLogoutRequest);
        }
    }

    protected void handleSingleLogoutForPostBinding(RequestContext context, LogoutRequest samlLogoutRequest, SamlRegisteredService samlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        SingleLogoutService sloService = adaptor.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        if (sloService != null) {
            LogoutResponse logoutResponse = this.buildSamlLogoutResponse(adaptor, sloService, context, samlRegisteredService, samlLogoutRequest);
            this.postSamlLogoutResponse(sloService, logoutResponse, context);
        }
    }

    protected void produceSamlLogoutResponseRedirect(SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SingleLogoutService sloService, RequestContext context, SamlRegisteredService registeredService, LogoutRequest logoutRequest) {
        LogoutResponse logoutResponse = this.buildSamlLogoutResponse(adaptor, sloService, context, registeredService, logoutRequest);
        String location = StringUtils.isBlank((CharSequence)sloService.getResponseLocation()) ? sloService.getLocation() : sloService.getResponseLocation();
        LOGGER.trace("Encoding logout response given endpoint [{}] for binding [{}]", (Object)location, (Object)sloService.getBinding());
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        SamlIdPHttpRedirectDeflateEncoder encoder = new SamlIdPHttpRedirectDeflateEncoder(location, (SignableXMLObject)logoutResponse);
        encoder.setRelayState(request.getParameter("RelayState"));
        encoder.doEncode();
        String redirectUrl = encoder.getRedirectUrl();
        LOGGER.debug("Final logout redirect URL is [{}]", (Object)redirectUrl);
        WebUtils.putLogoutRedirectUrl((HttpServletRequest)request, (String)redirectUrl);
    }

    protected void postSamlLogoutResponse(SingleLogoutService sloService, LogoutResponse logoutResponse, RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String payload = SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)logoutResponse));
        LOGGER.trace("Logout request payload is [{}]", (Object)payload);
        String message = EncodingUtils.encodeBase64((String)payload);
        LOGGER.trace("Logout message encoded in base64 is [{}]", (Object)message);
        String location = StringUtils.isBlank((CharSequence)sloService.getResponseLocation()) ? sloService.getLocation() : sloService.getResponseLocation();
        LOGGER.debug("Sending logout response using [{}] binding to [{}]", (Object)sloService.getBinding(), (Object)location);
        Map parameters = CollectionUtils.wrap((String)"SAMLResponse", (Object)message);
        String relayState = request.getParameter("RelayState");
        FunctionUtils.doIfNotNull((Object)relayState, value -> parameters.put("RelayState", value));
        HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.POST).url(location).parameters(parameters).headers(CollectionUtils.wrap((String)"Content-Type", (Object)"application/xml")).build();
        HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
    }

    protected LogoutResponse buildSamlLogoutResponse(SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SingleLogoutService sloService, RequestContext requestContext, SamlRegisteredService registeredService, LogoutRequest logoutRequest) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        String id = "_" + String.valueOf(RandomUtils.nextLong());
        SamlIdPLogoutResponseObjectBuilder builder = this.configurationContext.getLogoutResponseBuilder();
        Status status = builder.newStatus("urn:oasis:names:tc:SAML:2.0:status:Success", "Success");
        Issuer issuer = builder.newIssuer(this.configurationContext.getCasProperties().getAuthn().getSamlIdp().getCore().getEntityId());
        String location = StringUtils.isBlank((CharSequence)sloService.getResponseLocation()) ? sloService.getLocation() : sloService.getResponseLocation();
        LOGGER.trace("Creating logout response for binding [{}] with issuer [{}], location [{}] and service provider [{}]", new Object[]{sloService.getBinding(), issuer, location, adaptor.getEntityId()});
        LogoutResponse logoutResponse = builder.newLogoutResponse(id, location, issuer, status, adaptor.getEntityId());
        if (this.configurationContext.getCasProperties().getAuthn().getSamlIdp().getLogout().isSignLogoutResponse()) {
            LOGGER.trace("Signing logout request for service provider [{}]", (Object)adaptor.getEntityId());
            LogoutResponse logoutResponseSigned = this.configurationContext.getSamlObjectSigner().encode(logoutResponse, registeredService, adaptor, response, request, sloService.getBinding(), (RequestAbstractType)logoutRequest);
            SamlUtils.logSamlObject((OpenSamlConfigBean)this.configurationContext.getOpenSamlConfigBean(), (XMLObject)logoutResponseSigned);
            return logoutResponseSigned;
        }
        return logoutResponse;
    }

    private Optional<LogoutRequest> getLogoutRequest(HttpServletRequest request) {
        String logoutRequest = WebUtils.getSingleLogoutRequest((HttpServletRequest)request);
        return Optional.ofNullable(logoutRequest).map(req -> {
            byte[] decodedRequest = EncodingUtils.decodeBase64((String)logoutRequest);
            return (LogoutRequest)SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configurationContext.getOpenSamlConfigBean(), (byte[])decodedRequest, LogoutRequest.class);
        });
    }

    @Generated
    public SamlIdPSingleLogoutRedirectionStrategy(SamlProfileHandlerConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }
}

