/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.sso;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPCoreProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.web.support.WebUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidator;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

public class SSOSamlIdPProfileCallbackHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOSamlIdPProfileCallbackHandlerController.class);

    public SSOSamlIdPProfileCallbackHandlerController(SamlProfileHandlerConfigurationContext config) {
        super(config);
    }

    protected Pair<AuthnRequest, MessageContext> buildAuthenticationContextPair(HttpServletRequest request, HttpServletResponse response, AuthnRequest authnRequest) {
        MessageContext messageContext = this.bindRelayStateParameter(request, response);
        return Pair.of((Object)authnRequest, (Object)messageContext);
    }

    @GetMapping(path={"/idp/profile/SAML2/Callback"})
    protected ModelAndView handleCallbackProfileRequestGet(HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.autoConfigureCookiePath(request);
        CasConfigurationProperties properties = this.configurationContext.getCasProperties();
        SamlIdPCoreProperties.SessionStorageTypes type = properties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
        if (type == SamlIdPCoreProperties.SessionStorageTypes.BROWSER_SESSION_STORAGE && !request.getParameterMap().containsKey("sessionStorage")) {
            return new ModelAndView("storage/casSessionStorageReadView");
        }
        return this.handleProfileRequest(response, request);
    }

    @PostMapping(path={"/idp/profile/SAML2/Callback"})
    protected ModelAndView handleCallbackProfileRequestPost(HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.autoConfigureCookiePath(request);
        CasConfigurationProperties properties = this.configurationContext.getCasProperties();
        SamlIdPCoreProperties.SessionStorageTypes type = properties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
        if (type == SamlIdPCoreProperties.SessionStorageTypes.BROWSER_SESSION_STORAGE) {
            String storage = request.getParameter("sessionStorage");
            JEEContext context = new JEEContext(request, response);
            this.configurationContext.getSessionStore().buildFromTrackableSession((WebContext)context, (Object)storage);
            return this.handleProfileRequest(response, request);
        }
        return WebUtils.produceErrorView((Exception)new IllegalArgumentException("Unable to build SAML response"));
    }

    protected String determineProfileBinding(Pair<AuthnRequest, MessageContext> authenticationContext, Assertion assertion) {
        AuthnRequest authnRequest = (AuthnRequest)authenticationContext.getKey();
        Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> pair = this.getRegisteredServiceAndFacade(authnRequest);
        SamlRegisteredServiceServiceProviderMetadataFacade facade = (SamlRegisteredServiceServiceProviderMetadataFacade)pair.getValue();
        String binding = (String)StringUtils.defaultIfBlank((CharSequence)authnRequest.getProtocolBinding(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        LOGGER.debug("Determined authentication request binding is [{}], issued by [{}]", (Object)binding, (Object)authnRequest.getIssuer().getValue());
        String entityId = facade.getEntityId();
        LOGGER.debug("Checking metadata for [{}] to see if binding [{}] is supported", (Object)entityId, (Object)binding);
        AssertionConsumerService svc = facade.getAssertionConsumerService(binding);
        if (svc != null) {
            LOGGER.debug("Binding [{}] is supported by [{}]", (Object)svc.getBinding(), (Object)entityId);
            return binding;
        }
        LOGGER.warn("Checking determine profile binding for [{}]", (Object)entityId);
        return null;
    }

    private ModelAndView handleProfileRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        Assertion assertion;
        LOGGER.info("Received SAML callback profile request [{}]", (Object)request.getRequestURI());
        AuthnRequest authnRequest = (AuthnRequest)SamlIdPUtils.retrieveSamlRequest((WebContext)new JEEContext(request, response), (SessionStore)this.configurationContext.getSessionStore(), (OpenSamlConfigBean)this.configurationContext.getOpenSamlConfigBean(), AuthnRequest.class);
        String ticket = request.getParameter("ticket");
        if (StringUtils.isBlank((CharSequence)ticket)) {
            LOGGER.error("Can not validate the request because no [{}] is provided via the request", (Object)"ticket");
            return WebUtils.produceErrorView((Exception)new IllegalArgumentException("Unable to handle SAML request"));
        }
        Pair<AuthnRequest, MessageContext> authenticationContext = this.buildAuthenticationContextPair(request, response, authnRequest);
        String binding = this.determineProfileBinding(authenticationContext, assertion = this.validateRequestAndBuildCasAssertion(response, request, authenticationContext));
        if (StringUtils.isBlank((CharSequence)binding)) {
            LOGGER.error("Unable to determine profile binding");
            return WebUtils.produceErrorView((Exception)new IllegalArgumentException("Unable to determine profile binding"));
        }
        this.buildSamlResponse(response, request, authenticationContext, assertion, binding);
        return null;
    }

    private MessageContext bindRelayStateParameter(HttpServletRequest request, HttpServletResponse response) {
        MessageContext messageContext = new MessageContext();
        JEEContext context = new JEEContext(request, response);
        String relayState = this.configurationContext.getSessionStore().get((WebContext)context, "RelayState").orElse("").toString();
        LOGGER.trace("Relay state is [{}]", (Object)relayState);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)relayState);
        return messageContext;
    }

    private Assertion validateRequestAndBuildCasAssertion(HttpServletResponse response, HttpServletRequest request, Pair<AuthnRequest, MessageContext> pair) throws Exception {
        String ticket = request.getParameter("ticket");
        TicketValidator validator = this.getConfigurationContext().getTicketValidator();
        String serviceUrl = this.constructServiceUrl(request, response, pair);
        LOGGER.trace("Created service url for validation: [{}]", (Object)serviceUrl);
        Assertion assertion = validator.validate(ticket, serviceUrl);
        SSOSamlIdPProfileCallbackHandlerController.logCasValidationAssertion(assertion);
        return assertion;
    }
}

