/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.consent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.consent.CasConsentableAttribute;
import org.apereo.cas.consent.ConsentableAttributeBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlIdPAttributeDefinition;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;

public class SamlIdPConsentableAttributeBuilder
implements ConsentableAttributeBuilder {
    private final AttributeDefinitionStore attributeDefinitionStore;

    public CasConsentableAttribute build(CasConsentableAttribute attribute) {
        Optional result = this.attributeDefinitionStore.locateAttributeDefinition(defn -> {
            if (defn instanceof SamlIdPAttributeDefinition) {
                SamlIdPAttributeDefinition samlAttr = (SamlIdPAttributeDefinition)((Object)defn);
                return (StringUtils.equalsIgnoreCase((CharSequence)samlAttr.getKey(), (CharSequence)attribute.getName()) || StringUtils.equalsIgnoreCase((CharSequence)samlAttr.getUrn(), (CharSequence)attribute.getName())) && StringUtils.isNotBlank((CharSequence)samlAttr.getFriendlyName());
            }
            return false;
        });
        if (result.isPresent()) {
            SamlIdPAttributeDefinition samlAttr = (SamlIdPAttributeDefinition)((Object)result.get());
            attribute.setFriendlyName(samlAttr.getFriendlyName());
        }
        List attributeValues = (List)ObjectUtils.defaultIfNull((Object)attribute.getValues(), new ArrayList());
        attributeValues.replaceAll(o -> {
            if (o instanceof XSString) {
                return ((XSString)o).getValue();
            }
            if (o instanceof XSURI) {
                return ((XSURI)o).getURI();
            }
            if (o instanceof Serializable) {
                return o;
            }
            return o.toString();
        });
        return attribute;
    }

    @Generated
    public SamlIdPConsentableAttributeBuilder(AttributeDefinitionStore attributeDefinitionStore) {
        this.attributeDefinitionStore = attributeDefinitionStore;
    }
}

