/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.support.saml.mdui.MetadataUIUtils;
import org.apereo.cas.support.saml.mdui.SamlMetadataUIInfo;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SamlIdPMetadataUIAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPMetadataUIAction.class);
    private final ServicesManager servicesManager;
    private final SamlRegisteredServiceCachingMetadataResolver resolver;
    private final AuthenticationServiceSelectionPlan serviceSelectionStrategy;

    protected Event doExecute(RequestContext requestContext) {
        SamlRegisteredService samlService;
        Service service = this.serviceSelectionStrategy.resolveService((Service)WebUtils.getService((RequestContext)requestContext));
        if (service != null && (samlService = (SamlRegisteredService)this.servicesManager.findServiceBy(service, SamlRegisteredService.class)) != null) {
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)samlService);
            Optional adaptor = SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.resolver, (SamlRegisteredService)samlService, (String)service.getId());
            if (adaptor.isEmpty()) {
                LOGGER.debug("Cannot find SAML2 metadata linked to [{}]. Skipping MDUI...", (Object)service.getId());
                return this.success();
            }
            SamlMetadataUIInfo mdui = MetadataUIUtils.locateMetadataUserInterfaceForEntityId((EntityDescriptor)((SamlRegisteredServiceServiceProviderMetadataFacade)adaptor.get()).entityDescriptor(), (String)service.getId(), (WebBasedRegisteredService)samlService, (HttpServletRequest)WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext));
            WebUtils.putServiceUserInterfaceMetadata((RequestContext)requestContext, (Serializable)mdui);
        }
        return this.success();
    }

    @Generated
    public SamlIdPMetadataUIAction(ServicesManager servicesManager, SamlRegisteredServiceCachingMetadataResolver resolver, AuthenticationServiceSelectionPlan serviceSelectionStrategy) {
        this.servicesManager = servicesManager;
        this.resolver = resolver;
        this.serviceSelectionStrategy = serviceSelectionStrategy;
    }
}

