/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.delegation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pac4j.client.DelegatedClientAuthenticationRequestCustomizer;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.util.CollectionUtils;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.saml.client.SAML2Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SamlIdPDelegatedClientAuthenticationRequestCustomizer
implements DelegatedClientAuthenticationRequestCustomizer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPDelegatedClientAuthenticationRequestCustomizer.class);
    private final SessionStore sessionStore;
    private final OpenSamlConfigBean openSamlConfigBean;
    private final CasConfigurationProperties casProperties;

    public void customize(IndirectClient client, WebContext webContext) {
        Optional<AuthnRequest> result = SamlIdPUtils.retrieveSamlRequest((WebContext)webContext, (SessionStore)this.sessionStore, (OpenSamlConfigBean)this.openSamlConfigBean, AuthnRequest.class).map(Pair::getLeft).map(AuthnRequest.class::cast);
        result.ifPresent(authnRequest -> {
            LOGGER.debug("Retrieved the SAML2 authentication request from [{}]", (Object)SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest));
            if (authnRequest.isForceAuthn().booleanValue()) {
                this.customizeForceAuthnRequest(client, webContext, (AuthnRequest)authnRequest);
            }
            if (authnRequest.isPassive().booleanValue()) {
                this.customizePassiveAuthnRequest(client, webContext);
            }
            this.customizeAuthnContextClass(client, webContext, (AuthnRequest)authnRequest);
        });
    }

    public boolean isAuthorized(WebContext webContext, IndirectClient client, WebApplicationService currentService) {
        Optional result = SamlIdPUtils.retrieveSamlRequest((WebContext)webContext, (SessionStore)this.sessionStore, (OpenSamlConfigBean)this.openSamlConfigBean, AuthnRequest.class);
        if (result.isEmpty()) {
            LOGGER.trace("No SAML2 authentication request found in session store");
            return true;
        }
        AuthnRequest authnRequest = (AuthnRequest)((Pair)result.get()).getLeft();
        LOGGER.trace("Retrieved the SAML2 authentication request from [{}]", (Object)SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest));
        IDPList idpList = authnRequest.getScoping() != null ? authnRequest.getScoping().getIDPList() : null;
        List idpEntries = idpList != null && idpList.getIDPEntrys() != null ? idpList.getIDPEntrys() : List.of();
        List providerList = idpEntries.stream().map(IDPEntry::getProviderID).collect(Collectors.toList());
        LOGGER.debug("Scoped identity providers are [{}] to examine against client [{}]", providerList, (Object)client.getName());
        if (this.supports(client, webContext)) {
            SAML2Client saml2Client = (SAML2Client)client;
            LOGGER.debug("Comparing [{}] against scoped identity providers [{}]", (Object)saml2Client.getIdentityProviderResolvedEntityId(), providerList);
            return providerList.isEmpty() || providerList.contains(saml2Client.getIdentityProviderResolvedEntityId());
        }
        return true;
    }

    public boolean supports(IndirectClient client, WebContext webContext) {
        return client instanceof SAML2Client;
    }

    protected void customizeAuthnContextClass(IndirectClient client, WebContext webContext, AuthnRequest authnRequest) {
        RequestedAuthnContext requestedAuthnContext = authnRequest.getRequestedAuthnContext();
        if (requestedAuthnContext != null && requestedAuthnContext.getAuthnContextClassRefs() != null && !requestedAuthnContext.getAuthnContextClassRefs().isEmpty()) {
            List<String> authnContextClassRefs = requestedAuthnContext.getAuthnContextClassRefs().stream().map(XSURI::getURI).toList();
            Map definedContexts = CollectionUtils.convertDirectedListToMap((Collection)this.casProperties.getAuthn().getSamlIdp().getCore().getAuthenticationContextClassMappings());
            LOGGER.debug("Defined authentication context mappings are [{}]", (Object)definedContexts);
            List mappedMethods = authnContextClassRefs.stream().map(ref -> definedContexts.getOrDefault(ref, ref)).map(ref -> new ArrayList(StringUtils.commaDelimitedListToSet((String)ref))).flatMap(Collection::stream).toList();
            LOGGER.debug("Mapped authentication context classes are [{}]", mappedMethods);
            webContext.setRequestAttribute("AuthnContextClassRefs", mappedMethods);
            AuthnContextComparisonTypeEnumeration comparison = Optional.ofNullable(requestedAuthnContext.getComparison()).orElse(AuthnContextComparisonTypeEnumeration.EXACT);
            webContext.setRequestAttribute("ComparisonType", (Object)comparison.name());
        }
    }

    protected void customizePassiveAuthnRequest(IndirectClient client, WebContext webContext) {
        webContext.setRequestAttribute("Passive", (Object)true);
    }

    protected void customizeForceAuthnRequest(IndirectClient client, WebContext webContext, AuthnRequest authnRequest) {
        webContext.setRequestAttribute("ForceAuthn", (Object)true);
    }

    @Generated
    public SamlIdPDelegatedClientAuthenticationRequestCustomizer(SessionStore sessionStore, OpenSamlConfigBean openSamlConfigBean, CasConfigurationProperties casProperties) {
        this.sessionStore = sessionStore;
        this.openSamlConfigBean = openSamlConfigBean;
        this.casProperties = casProperties;
    }
}

