/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

public class SamlIdPInitiatedProfileHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPInitiatedProfileHandlerController.class);

    public SamlIdPInitiatedProfileHandlerController(SamlProfileHandlerConfigurationContext ctx) {
        super(ctx);
    }

    @GetMapping(path={"/idp/profile/SAML2/Unsolicited/SSO"})
    protected ModelAndView handleIdPInitiatedSsoRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        String providerId = this.extractProviderId(request);
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(providerId);
        Optional<SamlRegisteredServiceServiceProviderMetadataFacade> adaptor = this.getSamlMetadataFacadeFor(registeredService, providerId);
        if (adaptor.isEmpty()) {
            throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + providerId);
        }
        SamlRegisteredServiceServiceProviderMetadataFacade facade = adaptor.get();
        String shire = this.extractShire(request, providerId, facade);
        String target = request.getParameter("target");
        String time = request.getParameter("time");
        AuthnRequest authnRequest = this.buildAuthnRequest(providerId, shire, time);
        if (StringUtils.isNotBlank((CharSequence)target)) {
            request.setAttribute("RelayState", (Object)target);
        }
        MessageContext ctx = new MessageContext();
        if (facade.isAuthnRequestsSigned() || registeredService.isSignUnsolicitedAuthnRequest()) {
            this.getConfigurationContext().getSamlObjectSigner().encode(authnRequest, registeredService, facade, response, request, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (RequestAbstractType)authnRequest, ctx);
        }
        ctx.setMessage((Object)authnRequest);
        SAMLBindingContext bindingContext = (SAMLBindingContext)ctx.getSubcontext(SAMLBindingContext.class, true);
        Objects.requireNonNull(bindingContext).setHasBindingSignature(false);
        SAMLBindingSupport.setRelayState((MessageContext)ctx, (String)target);
        Pair pair = Pair.of((Object)authnRequest, (Object)ctx);
        ModelAndView modelAndView = this.initiateAuthenticationRequest((Pair<? extends RequestAbstractType, MessageContext>)pair, response, request);
        if (modelAndView != null) {
            RedirectView view = (RedirectView)modelAndView.getView();
            URIBuilder urlBuilder = new URIBuilder(Objects.requireNonNull(view).getUrl());
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String parameterName = (String)paramNames.nextElement();
                if (parameterName.equalsIgnoreCase("target") || parameterName.equalsIgnoreCase("time") || parameterName.equalsIgnoreCase("shire") || parameterName.equalsIgnoreCase("providerId")) continue;
                urlBuilder.addParameter(parameterName, request.getParameter(parameterName));
            }
            view.setUrl(urlBuilder.build().toString());
        }
        return modelAndView;
    }

    protected AuthnRequest buildAuthnRequest(String providerId, String shire, String time) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.getConfigurationContext().getOpenSamlConfigBean().getBuilderFactory().getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest authnRequest = (AuthnRequest)builder.buildObject();
        authnRequest.setAssertionConsumerServiceURL(shire);
        SAMLObjectBuilder isBuilder = (SAMLObjectBuilder)this.getConfigurationContext().getOpenSamlConfigBean().getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)isBuilder.buildObject();
        issuer.setValue(providerId);
        authnRequest.setIssuer(issuer);
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        SAMLObjectBuilder pBuilder = (SAMLObjectBuilder)this.getConfigurationContext().getOpenSamlConfigBean().getBuilderFactory().getBuilder(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        NameIDPolicy nameIDPolicy = (NameIDPolicy)pBuilder.buildObject();
        nameIDPolicy.setAllowCreate(Boolean.TRUE);
        authnRequest.setNameIDPolicy(nameIDPolicy);
        if (NumberUtils.isCreatable((String)time)) {
            authnRequest.setIssueInstant(Instant.ofEpochMilli(Long.parseLong(time)));
        } else {
            authnRequest.setIssueInstant(ZonedDateTime.now(ZoneOffset.UTC).toInstant());
        }
        authnRequest.setForceAuthn(Boolean.FALSE);
        return authnRequest;
    }

    protected String extractShire(HttpServletRequest request, String providerId, SamlRegisteredServiceServiceProviderMetadataFacade facade) throws MessageDecodingException {
        String shire = request.getParameter("shire");
        if (StringUtils.isBlank((CharSequence)shire)) {
            LOGGER.info("Resolving service provider assertion consumer service URL for [{}] and binding [{}]", (Object)providerId, (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            AssertionConsumerService acs = facade.getAssertionConsumerService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            String string = acs != null ? (StringUtils.isBlank((CharSequence)acs.getResponseLocation()) ? acs.getLocation() : acs.getResponseLocation()) : (shire = null);
        }
        if (StringUtils.isBlank((CharSequence)shire)) {
            LOGGER.warn("Unable to resolve service provider assertion consumer service URL for AuthnRequest construction for entityID: [{}]", (Object)providerId);
            throw new MessageDecodingException("Unable to resolve SP ACS URL for AuthnRequest construction");
        }
        return shire;
    }

    protected String extractProviderId(HttpServletRequest request) throws MessageDecodingException {
        String providerId = request.getParameter("providerId");
        if (StringUtils.isBlank((CharSequence)providerId)) {
            LOGGER.warn("No providerId parameter given in unsolicited SSO authentication request.");
            throw new MessageDecodingException("Missing providerId");
        }
        return providerId;
    }
}

