/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.artifact;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.impl.BasicSAMLArtifactMap;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.jee.context.JEEContext;

public class CasSamlArtifactMap
extends BasicSAMLArtifactMap {
    private final TicketRegistry ticketRegistry;
    private final TicketFactory ticketFactory;
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    private final SessionStore samlIdPDistributedSessionStore;

    public void put(@Nonnull String artifact, @Nonnull String relyingPartyId, @Nonnull String issuerId, @Nonnull SAMLObject samlMessage) throws IOException {
        super.put(artifact, relyingPartyId, issuerId, samlMessage);
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
        TicketGrantingTicket ticketGrantingTicket = CookieUtils.getTicketGrantingTicketFromRequest((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator, (TicketRegistry)this.ticketRegistry, (HttpServletRequest)request);
        if (ticketGrantingTicket == null) {
            JEEContext ctx = new JEEContext(request, response);
            ProfileManager manager = new ProfileManager((WebContext)ctx, this.samlIdPDistributedSessionStore);
            ticketGrantingTicket = manager.getProfile().map(profile -> profile.getAttribute(TicketGrantingTicket.class.getName())).map(ticketId -> (TicketGrantingTicket)this.ticketRegistry.getTicket(ticketId.toString(), TicketGrantingTicket.class)).orElse(null);
        }
        SamlArtifactTicketFactory samlArtifactTicketFactory = (SamlArtifactTicketFactory)this.ticketFactory.get(SamlArtifactTicket.class);
        SamlArtifactTicket ticket = samlArtifactTicketFactory.create(artifact, Objects.requireNonNull(ticketGrantingTicket).getAuthentication(), ticketGrantingTicket, issuerId, relyingPartyId, samlMessage);
        FunctionUtils.doUnchecked(__ -> this.ticketRegistry.addTicket((Ticket)ticket), (Object[])new Object[0]);
    }

    @Generated
    public CasSamlArtifactMap(TicketRegistry ticketRegistry, TicketFactory ticketFactory, CasCookieBuilder ticketGrantingTicketCookieGenerator, SessionStore samlIdPDistributedSessionStore) {
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.samlIdPDistributedSessionStore = samlIdPDistributedSessionStore;
    }
}

