/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.attr;

import java.util.Set;
import lombok.Generated;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.DefaultSaml20AttributeBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlRegisteredServiceAttributeBuilder
extends DefaultSaml20AttributeBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlRegisteredServiceAttributeBuilder.class);
    private final SamlRegisteredService service;
    private final SamlRegisteredServiceServiceProviderMetadataFacade adaptor;
    private final SamlIdPObjectEncrypter samlObjectEncrypter;

    public void build(AttributeStatement attrStatement, Attribute attribute) {
        if (!this.service.isEncryptAttributes() || !this.shouldEncryptAttribute(attribute) || this.service.isEncryptAssertions()) {
            LOGGER.debug("Service [{}] is configured to not encrypt attributes for [{}]", (Object)this.service.getName(), (Object)attribute.getName());
            super.build(attrStatement, attribute);
            return;
        }
        EncryptedAttribute encryptedAttribute = this.samlObjectEncrypter.encode(attribute, this.service, this.adaptor);
        if (encryptedAttribute != null) {
            LOGGER.debug("Encrypted attribute [{}] for service [{}]", (Object)attribute.getName(), (Object)this.service.getName());
            attrStatement.getEncryptedAttributes().add(encryptedAttribute);
        } else {
            LOGGER.debug("Unable to encrypt attribute [{}] for service [{}]", (Object)attribute.getName(), (Object)this.service.getName());
            super.build(attrStatement, attribute);
        }
    }

    private boolean shouldEncryptAttribute(Attribute attribute) {
        Set encryptableAttributes = this.service.getEncryptableAttributes();
        if (encryptableAttributes == null || encryptableAttributes.isEmpty() || encryptableAttributes.contains("*")) {
            LOGGER.debug("No explicit attribute encryption rules are defined; Attribute [{}] is selected for encryption.", (Object)attribute.getName());
            return true;
        }
        if (encryptableAttributes.contains(attribute.getName()) || encryptableAttributes.contains(attribute.getFriendlyName())) {
            LOGGER.debug("Attribute encryption rules allow [{}] to be encrypted", (Object)attribute.getName());
            return true;
        }
        LOGGER.debug("Skipping encryption as attribute encryption rules do NOT allow [{}] to be encrypted", (Object)attribute.getName());
        return false;
    }

    @Generated
    public SamlProfileSamlRegisteredServiceAttributeBuilder(SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlIdPObjectEncrypter samlObjectEncrypter) {
        this.service = service;
        this.adaptor = adaptor;
        this.samlObjectEncrypter = samlObjectEncrypter;
    }
}

