/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.nameid;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.apereo.cas.support.saml.web.idp.profile.builders.nameid.SamlAttributeBasedNameIdGenerator;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.profile.SAML2NameIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlNameIdBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<SAMLObject> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlNameIdBuilder.class);
    private static final long serialVersionUID = -6231886395225437320L;
    private final PersistentIdGenerator persistentIdGenerator;
    private final MetadataResolver samlIdPMetadataResolver;
    private final SamlIdPObjectEncrypter samlIdPObjectEncrypter;

    public SamlProfileSamlNameIdBuilder(OpenSamlConfigBean configBean, PersistentIdGenerator persistentIdGenerator, MetadataResolver samlIdPMetadataResolver, SamlIdPObjectEncrypter samlIdPObjectEncrypter) {
        super(configBean);
        this.persistentIdGenerator = persistentIdGenerator;
        this.samlIdPMetadataResolver = samlIdPMetadataResolver;
        this.samlIdPObjectEncrypter = samlIdPObjectEncrypter;
    }

    protected static List<String> getSupportedNameIdFormats(SamlProfileBuilderContext context) {
        ArrayList<String> supportedNameFormats = new ArrayList<String>(context.getAdaptor().getSupportedNameIdFormats());
        LOGGER.debug("Metadata for [{}] declares the following NameIDs [{}]", (Object)context.getAdaptor().getEntityId(), supportedNameFormats);
        if (supportedNameFormats.isEmpty()) {
            supportedNameFormats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
            LOGGER.debug("No supported nameId formats could be determined from metadata. Added default [{}]", (Object)"urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        }
        if (StringUtils.isNotBlank((CharSequence)context.getRegisteredService().getRequiredNameIdFormat())) {
            String fmt = SamlProfileSamlNameIdBuilder.parseAndBuildRequiredNameIdFormat(context.getRegisteredService());
            supportedNameFormats.add(0, fmt);
            LOGGER.debug("Added required nameId format [{}] based on saml service configuration for [{}]", (Object)fmt, (Object)context.getRegisteredService().getServiceId());
        }
        return supportedNameFormats;
    }

    private static String parseAndBuildRequiredNameIdFormat(SamlRegisteredService service) {
        String fmt = StringUtils.defaultString((String)service.getRequiredNameIdFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified").trim();
        LOGGER.debug("Required NameID format assigned to service [{}] is [{}]", (Object)service.getName(), (Object)fmt);
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:transient", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:transient";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:entity", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:entity";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted";
        }
        return "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    }

    protected static String getRequiredNameIdFormatIfAny(SamlProfileBuilderContext context) {
        String requiredNameFormat = SamlIdPUtils.getNameIDPolicy((RequestAbstractType)context.getSamlRequest()).map(NameIDPolicy::getFormat).orElse(null);
        LOGGER.debug("AuthN request indicates [{}] is the required NameID format", (Object)requiredNameFormat);
        return requiredNameFormat;
    }

    @Override
    public SAMLObject build(SamlProfileBuilderContext context) throws SamlException {
        if (context.getSamlRequest() instanceof AttributeQuery) {
            return this.determineNameIdForAttributeQuery(context);
        }
        return this.buildNameId(context);
    }

    protected NameID buildNameId(SamlProfileBuilderContext context) throws SamlException {
        List<String> supportedNameFormats = SamlProfileSamlNameIdBuilder.getSupportedNameIdFormats(context);
        String requiredNameFormat = SamlProfileSamlNameIdBuilder.getRequiredNameIdFormatIfAny(context);
        this.validateRequiredNameIdFormatIfAny(supportedNameFormats, requiredNameFormat, context);
        NameID nameID = this.determineNameId(supportedNameFormats, context);
        return this.finalizeNameId(nameID, context);
    }

    protected NameID finalizeNameId(NameID nameid, SamlProfileBuilderContext context) {
        if (nameid != null) {
            SamlRegisteredService registeredService = context.getRegisteredService();
            if (!StringUtils.equalsIgnoreCase((CharSequence)registeredService.getNameIdQualifier(), (CharSequence)"none") && !registeredService.isSkipGeneratingNameIdQualifier()) {
                if (StringUtils.isNotBlank((CharSequence)registeredService.getNameIdQualifier())) {
                    nameid.setNameQualifier(registeredService.getNameIdQualifier());
                } else {
                    nameid.setNameQualifier(SamlIdPUtils.determineNameIdNameQualifier((SamlRegisteredService)registeredService, (MetadataResolver)this.samlIdPMetadataResolver));
                }
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)registeredService.getServiceProviderNameIdQualifier(), (CharSequence)"none") && !registeredService.isSkipGeneratingServiceProviderNameIdQualifier()) {
                FunctionUtils.doIf((boolean)StringUtils.isNotBlank((CharSequence)registeredService.getServiceProviderNameIdQualifier()), value -> nameid.setSPNameQualifier(registeredService.getServiceProviderNameIdQualifier()), value -> nameid.setSPNameQualifier(context.getAdaptor().getEntityId())).accept(registeredService);
            }
        }
        return nameid;
    }

    protected void validateRequiredNameIdFormatIfAny(List<String> supportedNameFormats, String requiredNameFormat, SamlProfileBuilderContext context) {
        if (StringUtils.isNotBlank((CharSequence)requiredNameFormat) && !supportedNameFormats.contains(requiredNameFormat)) {
            LOGGER.warn("Required NameID format [{}] in the AuthN request issued by [{}] is not supported based on the metadata for [{}]. The requested NameID format may not be honored. You should consult the metadata for this service and ensure the requested NameID format is present in the collection of supported metadata formats in the metadata, which are the following: [{}]", new Object[]{requiredNameFormat, SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)context.getSamlRequest()), context.getAdaptor().getEntityId(), context.getAdaptor().getSupportedNameIdFormats()});
        }
    }

    protected NameID determineNameId(List<String> supportedNameFormats, SamlProfileBuilderContext context) {
        for (String nameFormat : supportedNameFormats) {
            LOGGER.debug("Evaluating NameID format [{}]", (Object)nameFormat);
            NameID nameId = this.encodeNameIdBasedOnNameFormat(context, nameFormat);
            if (nameId == null) continue;
            LOGGER.debug("Determined NameID based on format [{}] to be [{}]", (Object)nameFormat, (Object)nameId.getValue());
            return nameId;
        }
        LOGGER.warn("No NameID could be determined based on the supported formats [{}]", supportedNameFormats);
        return null;
    }

    protected NameID encodeNameIdBasedOnNameFormat(SamlProfileBuilderContext context, String nameFormat) {
        try {
            String attribute = this.prepareNameIdAttribute(context, nameFormat);
            SAML2NameIDGenerator encoder = SamlAttributeBasedNameIdGenerator.get(Optional.of(context.getSamlRequest()), nameFormat, context.getRegisteredService(), attribute);
            context.getHttpRequest().setAttribute(NameID.class.getName(), (Object)attribute);
            LOGGER.debug("Encoding NameID based on [{}]", (Object)nameFormat);
            ProfileRequestContext prc = new ProfileRequestContext();
            NameID nameId = Objects.requireNonNull(encoder.generate(prc, nameFormat));
            LOGGER.debug("Final NameID encoded with format [{}] has value [{}]", (Object)nameId.getFormat(), (Object)nameId.getValue());
            return nameId;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    protected String prepareNameIdAttribute(SamlProfileBuilderContext context, String nameFormat) {
        String principalId = context.getAuthenticatedAssertion().get().getName();
        LOGGER.debug("Preparing NameID attribute for principal [{}]", (Object)principalId);
        String nameIdValue = this.getNameIdValueFromNameFormat(nameFormat, context);
        LOGGER.debug("NameID attribute value is set to [{}]", (Object)nameIdValue);
        return nameIdValue;
    }

    private String getNameIdValueFromNameFormat(String nameFormat, SamlProfileBuilderContext context) {
        String principalId = context.getAuthenticatedAssertion().get().getName();
        if (nameFormat.trim().equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:nameid-format:transient")) {
            String entityId = context.getAdaptor().getEntityId();
            if (context.getRegisteredService().isSkipGeneratingTransientNameId()) {
                LOGGER.debug("Generation of transient NameID value is skipped for [{}] and [{}] will be used instead", (Object)entityId, (Object)principalId);
            } else {
                LOGGER.debug("Generating transient NameID value for principal [{}] and entity id [{}]", (Object)principalId, (Object)entityId);
                return this.persistentIdGenerator.generate(principalId, entityId);
            }
        }
        return principalId;
    }

    private SAMLObject determineNameIdForAttributeQuery(SamlProfileBuilderContext context) {
        AttributeQuery query = (AttributeQuery)context.getSamlRequest();
        NameID result = query.getSubject().getNameID() == null ? this.samlIdPObjectEncrypter.decode(query.getSubject().getEncryptedID(), context.getRegisteredService(), context.getAdaptor()) : query.getSubject().getNameID();
        result.detach();
        return result;
    }
}

