/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.response;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSamlResponseBuilderConfigurationContext;
import org.apereo.inspektr.audit.annotation.Audit;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.ScratchContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSamlProfileSamlResponseBuilder<T extends XMLObject>
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSamlProfileSamlResponseBuilder.class);
    private static final long serialVersionUID = -1891703354216174875L;
    protected final SamlProfileSamlResponseBuilderConfigurationContext configurationContext;

    protected BaseSamlProfileSamlResponseBuilder(SamlProfileSamlResponseBuilderConfigurationContext ctx) {
        super(ctx.getOpenSamlConfigBean());
        this.configurationContext = ctx;
    }

    @Override
    @Audit(action="SAML2_RESPONSE", actionResolverName="SAML2_RESPONSE_ACTION_RESOLVER", resourceResolverName="SAML2_RESPONSE_RESOURCE_RESOLVER")
    public T build(SamlProfileBuilderContext context) throws Exception {
        Optional<Assertion> assertion = context.getAuthenticatedAssertion().isPresent() ? Optional.of(this.buildSamlAssertion(context)) : Optional.empty();
        T finalResponse = this.buildResponse(assertion, context);
        return this.encodeFinalResponse(context, finalResponse);
    }

    protected T encodeFinalResponse(SamlProfileBuilderContext context, T finalResponse) throws Exception {
        ScratchContext scratch = (ScratchContext)context.getMessageContext().getSubcontext(ScratchContext.class, true);
        Map map = Objects.requireNonNull(scratch).getMap();
        Boolean encodeResponse = map.getOrDefault("encodeSamlResponse", Boolean.TRUE);
        if (encodeResponse.booleanValue()) {
            String relayState = SAMLBindingSupport.getRelayState((MessageContext)context.getMessageContext());
            LOGGER.trace("Relay state is [{}]", (Object)relayState);
            return this.encode(context, finalResponse, relayState);
        }
        return finalResponse;
    }

    protected Assertion buildSamlAssertion(SamlProfileBuilderContext context) throws Exception {
        return this.configurationContext.getSamlProfileSamlAssertionBuilder().build(context);
    }

    protected abstract T buildResponse(Optional<Assertion> var1, SamlProfileBuilderContext var2) throws Exception;

    protected Issuer buildSamlResponseIssuer(String entityId) {
        Issuer issuer = this.newIssuer(entityId);
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        return issuer;
    }

    protected abstract T encode(SamlProfileBuilderContext var1, T var2, String var3) throws Exception;

    protected Optional<SAMLObject> encryptAssertion(Optional<Assertion> assertion, SamlProfileBuilderContext context) {
        return assertion.map(result -> {
            if (this.encryptAssertionFor(context)) {
                LOGGER.debug("SAML service [{}] requires assertions to be encrypted", (Object)context.getAdaptor().getEntityId());
                EncryptedAssertion encrypted = this.configurationContext.getSamlObjectEncrypter().encode((Assertion)assertion.get(), context.getRegisteredService(), context.getAdaptor());
                if (encrypted == null) {
                    LOGGER.debug("SAML registered service [{}] is unable to encrypt assertions", (Object)context.getAdaptor().getEntityId());
                    return (SAMLObject)assertion.get();
                }
                return encrypted;
            }
            LOGGER.debug("SAML registered service [{}] does not require assertions to be encrypted", (Object)context.getAdaptor().getEntityId());
            return (SAMLObject)assertion.get();
        });
    }

    protected boolean encryptAssertionFor(SamlProfileBuilderContext context) {
        return context.getRegisteredService().isEncryptAssertions();
    }

    @Generated
    public SamlProfileSamlResponseBuilderConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }
}

