/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.response.soap;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.BaseSamlProfileSamlResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSamlResponseBuilderConfigurationContext;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPSOAP11Encoder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.ecp.Response;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlSoap11ResponseBuilder
extends BaseSamlProfileSamlResponseBuilder<Envelope> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlSoap11ResponseBuilder.class);
    private static final long serialVersionUID = -1875903354216171261L;

    public SamlProfileSamlSoap11ResponseBuilder(SamlProfileSamlResponseBuilderConfigurationContext samlResponseBuilderConfigurationContext) {
        super(samlResponseBuilderConfigurationContext);
    }

    @Override
    protected Envelope buildResponse(Optional<Assertion> assertion, SamlProfileBuilderContext context) throws Exception {
        LOGGER.debug("Locating the assertion consumer service url for binding [{}]", (Object)context.getBinding());
        AssertionConsumerService acs = context.getAdaptor().getAssertionConsumerService(context.getBinding());
        LOGGER.debug("Located assertion consumer service url [{}]", (Object)acs);
        Response ecpResponse = this.newEcpResponse(acs.getLocation());
        Header header = (Header)SamlUtils.newSoapObject(Header.class);
        header.getUnknownXMLObjects().add(ecpResponse);
        Body body = (Body)SamlUtils.newSoapObject(Body.class);
        org.opensaml.saml.saml2.core.Response saml2Response = this.buildSaml2Response(context);
        body.getUnknownXMLObjects().add(saml2Response);
        Envelope envelope = (Envelope)SamlUtils.newSoapObject(Envelope.class);
        envelope.setHeader(header);
        envelope.setBody(body);
        this.openSamlConfigBean.logObject((XMLObject)envelope);
        return envelope;
    }

    protected org.opensaml.saml.saml2.core.Response buildSaml2Response(SamlProfileBuilderContext context) throws Exception {
        return (org.opensaml.saml.saml2.core.Response)this.getConfigurationContext().getSamlSoapResponseBuilder().build(context);
    }

    @Override
    protected Envelope encode(SamlProfileBuilderContext context, Envelope envelope, String relayState) throws Exception {
        SOAP11Context ctx = (SOAP11Context)context.getMessageContext().getSubcontext(SOAP11Context.class, true);
        Objects.requireNonNull(ctx).setEnvelope(envelope);
        HTTPSOAP11Encoder encoder = new HTTPSOAP11Encoder();
        encoder.setHttpServletResponseSupplier(context::getHttpResponse);
        encoder.setMessageContext(context.getMessageContext());
        encoder.initialize();
        encoder.encode();
        return envelope;
    }
}

