/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.slo;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPLogoutProperties;
import org.apereo.cas.logout.slo.SingleLogoutUrl;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.sso.request.SSOSamlHttpRequestExtractor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.web.support.WebUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSamlSLOProfileHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSamlSLOProfileHandlerController.class);

    protected AbstractSamlSLOProfileHandlerController(SamlProfileHandlerConfigurationContext context) {
        super(context);
    }

    private void handleLogoutResponse(Pair<? extends SignableSAMLObject, MessageContext> pair) {
        LogoutResponse logoutResponse = (LogoutResponse)pair.getKey();
        LOGGER.debug("Received logout response from [{}]", (Object)SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)logoutResponse.getIssuer()));
        this.getConfigurationContext().getOpenSamlConfigBean().logObject((XMLObject)logoutResponse);
    }

    private void handleLogoutRequest(HttpServletResponse response, HttpServletRequest request, Pair<? extends SignableSAMLObject, MessageContext> pair) throws Exception {
        SamlProfileHandlerConfigurationContext configContext = this.getConfigurationContext();
        SamlIdPLogoutProperties logout = configContext.getCasProperties().getAuthn().getSamlIdp().getLogout();
        LogoutRequest logoutRequest = (LogoutRequest)pair.getKey();
        MessageContext ctx = (MessageContext)pair.getValue();
        if (logout.isForceSignedLogoutRequests() && !SAMLBindingSupport.isMessageSigned((MessageContext)ctx)) {
            throw new SAMLException("Logout request is not signed but should be.");
        }
        String entityId = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)logoutRequest);
        LOGGER.trace("SAML logout request from entity id [{}] is signed", (Object)entityId);
        WebApplicationService service = (WebApplicationService)configContext.getWebApplicationServiceFactory().createService(entityId);
        service.getAttributes().put("entityId", CollectionUtils.wrapList((Object[])new Object[]{entityId}));
        SamlRegisteredService registeredService = (SamlRegisteredService)configContext.getServicesManager().findServiceBy((Service)service, SamlRegisteredService.class);
        LOGGER.trace("SAML registered service tied to [{}] is [{}]", (Object)entityId, (Object)registeredService);
        SamlRegisteredServiceServiceProviderMetadataFacade facade = (SamlRegisteredServiceServiceProviderMetadataFacade)SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)configContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (String)entityId).get();
        if (SAMLBindingSupport.isMessageSigned((MessageContext)ctx)) {
            LOGGER.trace("Verifying signature on the SAML logout request for [{}]", (Object)entityId);
            configContext.getSamlObjectSignatureValidator().verifySamlProfileRequestIfNeeded((RequestAbstractType)logoutRequest, facade, request, ctx);
        }
        configContext.getOpenSamlConfigBean().logObject((XMLObject)logoutRequest);
        List logoutUrls = SingleLogoutUrl.from((RegisteredService)registeredService);
        if (!logoutUrls.isEmpty()) {
            String destination = ((SingleLogoutUrl)logoutUrls.iterator().next()).getUrl();
            WebUtils.putLogoutRedirectUrl((HttpServletRequest)request, (String)destination);
        }
        WebUtils.putRegisteredService((HttpServletRequest)request, (RegisteredService)registeredService);
        try (StringWriter writer = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configurationContext.getOpenSamlConfigBean(), (XMLObject)logoutRequest);){
            String encodedRequest = EncodingUtils.encodeBase64((byte[])writer.toString().getBytes(StandardCharsets.UTF_8));
            WebUtils.putSingleLogoutRequest((HttpServletRequest)request, (String)encodedRequest);
        }
        request.getServletContext().getRequestDispatcher("/logout").forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void handleSloProfileRequest(HttpServletResponse response, HttpServletRequest request, BaseHttpServletRequestXMLMessageDecoder decoder) throws Exception {
        SamlIdPLogoutProperties logout = this.getConfigurationContext().getCasProperties().getAuthn().getSamlIdp().getLogout();
        if (logout.isSingleLogoutCallbacksDisabled()) {
            LOGGER.info("Processing SAML2 IdP SLO requests is disabled");
            return;
        }
        SSOSamlHttpRequestExtractor extractor = this.getConfigurationContext().getSamlHttpRequestExtractor();
        Optional<Pair<? extends SignableSAMLObject, MessageContext>> result = extractor.extract(request, decoder, SignableSAMLObject.class);
        if (result.isPresent()) {
            Pair<? extends SignableSAMLObject, MessageContext> pair = result.get();
            if (pair.getKey() instanceof LogoutResponse) {
                this.handleLogoutResponse(pair);
            } else if (pair.getKey() instanceof LogoutRequest) {
                this.handleLogoutRequest(response, request, pair);
            }
        } else {
            LOGGER.trace("Unable to process logout request/response");
        }
    }
}

