/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.sso;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.session.SessionStorageTypes;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.ticket.TicketValidator;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.web.support.WebUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

public class SSOSamlIdPProfileCallbackHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOSamlIdPProfileCallbackHandlerController.class);

    public SSOSamlIdPProfileCallbackHandlerController(SamlProfileHandlerConfigurationContext config) {
        super(config);
    }

    @GetMapping(path={"/idp/profile/SAML2/Callback"})
    protected ModelAndView handleCallbackProfileRequestGet(HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.autoConfigureCookiePath(request);
        CasConfigurationProperties properties = this.configurationContext.getCasProperties();
        SessionStorageTypes type = properties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
        if (type == SessionStorageTypes.BROWSER_SESSION_STORAGE && !request.getParameterMap().containsKey("sessionStorage")) {
            return new ModelAndView("storage/casSessionStorageReadView");
        }
        return this.handleProfileRequest(response, request);
    }

    @PostMapping(path={"/idp/profile/SAML2/Callback"})
    protected ModelAndView handleCallbackProfileRequestPost(HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.autoConfigureCookiePath(request);
        CasConfigurationProperties properties = this.configurationContext.getCasProperties();
        SessionStorageTypes type = properties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
        if (type == SessionStorageTypes.BROWSER_SESSION_STORAGE) {
            String storage = request.getParameter("sessionStorage");
            JEEContext context = new JEEContext(request, response);
            this.configurationContext.getSessionStore().buildFromTrackableSession((WebContext)context, (Object)storage);
            return this.handleProfileRequest(response, request);
        }
        return WebUtils.produceErrorView((Throwable)new IllegalArgumentException("Unable to build SAML response"));
    }

    private ModelAndView handleProfileRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        AuthnRequest authnRequest;
        Object object;
        Pair<? extends RequestAbstractType, MessageContext> authnContext = this.retrieveAuthenticationRequest(response, request);
        String ticket = request.getParameter("ticket");
        if (StringUtils.isBlank((CharSequence)ticket) && (object = authnContext.getKey()) instanceof AuthnRequest && !(authnRequest = (AuthnRequest)object).isPassive().booleanValue()) {
            LOGGER.error("Can not validate the request because no [{}] is provided via the request", (Object)"ticket");
            return WebUtils.produceErrorView((Throwable)new IllegalArgumentException("Unable to handle SAML request"));
        }
        Pair<? extends RequestAbstractType, MessageContext> authenticationContext = this.buildAuthenticationContextPair(request, response, authnContext);
        Optional<AuthenticatedAssertionContext> assertion = this.validateRequestAndBuildCasAssertion(response, request, authenticationContext);
        String binding = this.determineProfileBinding(authenticationContext);
        if (StringUtils.isBlank((CharSequence)binding)) {
            LOGGER.error("Unable to determine profile binding");
            return WebUtils.produceErrorView((Throwable)new IllegalArgumentException("Unable to determine profile binding"));
        }
        XMLObject resultObject = this.buildSamlResponse(response, request, authenticationContext, assertion, binding);
        request.setAttribute(Response.class.getName(), (Object)resultObject);
        return null;
    }

    protected Optional<AuthenticatedAssertionContext> validateRequestAndBuildCasAssertion(HttpServletResponse response, HttpServletRequest request, Pair<? extends RequestAbstractType, MessageContext> authnContext) throws Exception {
        AuthnRequest authnRequest;
        Object object;
        String ticket = request.getParameter("ticket");
        if (StringUtils.isBlank((CharSequence)ticket) && (object = authnContext.getKey()) instanceof AuthnRequest && (authnRequest = (AuthnRequest)object).isPassive().booleanValue()) {
            LOGGER.info("Unable to establish authentication context for passive authentication request");
            return Optional.empty();
        }
        TicketValidator validator = this.getConfigurationContext().getTicketValidator();
        String serviceUrl = this.constructServiceUrl(request, response, authnContext);
        LOGGER.trace("Created service url for validation: [{}]", (Object)serviceUrl);
        TicketValidator.ValidationResult assertion = validator.validate(ticket, serviceUrl);
        SSOSamlIdPProfileCallbackHandlerController.logCasValidationAssertion(assertion);
        Assertion asserted = (Assertion)assertion.getContext().get(Assertion.class.getName());
        Objects.requireNonNull(asserted, "Validation assertion cannot be null");
        return Optional.of(((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)AuthenticatedAssertionContext.builder().name(assertion.getPrincipal().getId())).authenticationDate(DateTimeUtils.zonedDateTimeOf((TemporalAccessor)asserted.primaryAuthentication().getAuthenticationDate()))).attributes(CollectionUtils.merge((Map[])new Map[]{assertion.getAttributes(), assertion.getPrincipal().getAttributes()}))).build());
    }
}

