/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.springframework.context.ApplicationContext;

public class SamlIdPMultifactorAuthenticationTrigger
implements MultifactorAuthenticationTrigger {
    private final OpenSamlConfigBean openSamlConfigBean;
    private final SessionStore distributedSessionStore;
    private final ApplicationContext applicationContext;
    private final CasConfigurationProperties casProperties;

    public Optional<MultifactorAuthenticationProvider> isActivated(Authentication authentication, RegisteredService registeredService, HttpServletRequest request, HttpServletResponse response, Service service) {
        JEEContext context = new JEEContext(request, response);
        Optional result = SamlIdPUtils.retrieveSamlRequest((WebContext)context, (SessionStore)this.distributedSessionStore, (OpenSamlConfigBean)this.openSamlConfigBean, AuthnRequest.class);
        Map<String, String> mappings = this.getAuthenticationContextMappings();
        return result.map(pair -> (AuthnRequest)pair.getLeft()).flatMap(authnRequest -> authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs().stream().filter(Objects::nonNull).filter(ref -> StringUtils.isNotBlank((CharSequence)ref.getURI())).filter(ref -> {
            String clazz = ref.getURI();
            return mappings.containsKey(clazz);
        }).findFirst().map(mapped -> (String)mappings.get(mapped.getURI()))).flatMap(id -> {
            Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
            return MultifactorAuthenticationUtils.resolveProvider((Map)providerMap, (String)id);
        });
    }

    public boolean supports(HttpServletRequest request, RegisteredService registeredService, Authentication authentication, Service service) {
        HttpServletResponse response;
        JEEContext context;
        Optional result;
        if (!this.getAuthenticationContextMappings().isEmpty() && (result = SamlIdPUtils.retrieveSamlRequest((WebContext)(context = new JEEContext(request, response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes())), (SessionStore)this.distributedSessionStore, (OpenSamlConfigBean)this.openSamlConfigBean, AuthnRequest.class)).isPresent()) {
            AuthnRequest authnRequest = (AuthnRequest)((Pair)result.get()).getLeft();
            return authnRequest.getRequestedAuthnContext() != null && authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs() != null && !authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs().isEmpty();
        }
        return false;
    }

    protected Map<String, String> getAuthenticationContextMappings() {
        List authnContexts = this.casProperties.getAuthn().getSamlIdp().getCore().getAuthenticationContextClassMappings();
        return CollectionUtils.convertDirectedListToMap((Collection)authnContexts);
    }

    @Generated
    public SamlIdPMultifactorAuthenticationTrigger(OpenSamlConfigBean openSamlConfigBean, SessionStore distributedSessionStore, ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        this.openSamlConfigBean = openSamlConfigBean;
        this.distributedSessionStore = distributedSessionStore;
        this.applicationContext = applicationContext;
        this.casProperties = casProperties;
    }
}

