/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.slo;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.logout.slo.BaseSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutUrl;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.UrlValidator;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlIdPSingleLogoutServiceLogoutUrlBuilder
extends BaseSingleLogoutServiceLogoutUrlBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPSingleLogoutServiceLogoutUrlBuilder.class);
    public static final String PROPERTY_NAME_SINGLE_LOGOUT_BINDING = "singleLogoutSamlBinding";
    protected final SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver;
    protected final List<String> logoutRequestBindings;

    public SamlIdPSingleLogoutServiceLogoutUrlBuilder(ServicesManager servicesManager, SamlRegisteredServiceCachingMetadataResolver resolver, UrlValidator urlValidator, SamlIdPProperties samlIdPProperties) {
        super(servicesManager, urlValidator);
        this.samlRegisteredServiceCachingMetadataResolver = resolver;
        this.logoutRequestBindings = samlIdPProperties.getLogout().getLogoutRequestBindings();
    }

    public boolean supports(RegisteredService registeredService, WebApplicationService singleLogoutService, Optional<HttpServletRequest> httpRequest) {
        return super.supports(registeredService, singleLogoutService, httpRequest) && registeredService instanceof SamlRegisteredService && registeredService.getAccessStrategy().isServiceAccessAllowed(registeredService, (Service)singleLogoutService) && this.buildLogoutUrl(registeredService, singleLogoutService) != null;
    }

    public Collection<SingleLogoutUrl> determineLogoutUrl(RegisteredService registeredService, WebApplicationService singleLogoutService, Optional<HttpServletRequest> httpRequest) {
        try {
            SingleLogoutUrl location = this.buildLogoutUrl(registeredService, singleLogoutService);
            if (location != null) {
                LOGGER.debug("Final logout URL built for [{}] is [{}]", (Object)registeredService, (Object)location);
                return CollectionUtils.wrap((Object)location);
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        LOGGER.trace("Service [{}] is not a SAML service, or its logout url could not be determined", (Object)registeredService);
        return new ArrayList<SingleLogoutUrl>(0);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private SingleLogoutUrl buildLogoutUrl(RegisteredService registeredService, WebApplicationService singleLogoutService) {
        LOGGER.trace("Building logout url for SAML service [{}]", (Object)registeredService);
        String entityID = singleLogoutService.getId();
        LOGGER.trace("Located entity id [{}]", (Object)entityID);
        SamlRegisteredService samlRegisteredService = (SamlRegisteredService)registeredService;
        Optional adaptorRes = SamlRegisteredServiceMetadataAdaptor.get((SamlRegisteredServiceCachingMetadataResolver)this.samlRegisteredServiceCachingMetadataResolver, (SamlRegisteredService)samlRegisteredService, (String)entityID);
        if (adaptorRes.isEmpty()) {
            LOGGER.warn("Cannot find metadata linked to [{}]", (Object)entityID);
            return null;
        }
        SamlRegisteredServiceMetadataAdaptor adaptor = (SamlRegisteredServiceMetadataAdaptor)adaptorRes.get();
        for (String binding : this.logoutRequestBindings) {
            SingleLogoutService sloService = adaptor.getSingleLogoutService(binding);
            if (sloService == null) continue;
            return SamlIdPSingleLogoutServiceLogoutUrlBuilder.finalizeSingleLogoutUrl(sloService, samlRegisteredService);
        }
        LOGGER.warn("Cannot find SLO service in metadata for entity id [{}]", (Object)entityID);
        return null;
    }

    private static SingleLogoutUrl finalizeSingleLogoutUrl(SingleLogoutService sloService, SamlRegisteredService service) {
        String location = StringUtils.isBlank((CharSequence)sloService.getResponseLocation()) ? sloService.getLocation() : sloService.getResponseLocation();
        SingleLogoutUrl url = new SingleLogoutUrl(location, service.getLogoutType());
        url.getProperties().put(PROPERTY_NAME_SINGLE_LOGOUT_BINDING, sloService.getBinding());
        return url;
    }
}

