/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.metadata;

import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="samlIdPMetadataController")
public class SamlIdPMetadataController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPMetadataController.class);
    private static final String CONTENT_TYPE = "text/xml;charset=UTF-8";
    private final SamlIdPMetadataGenerator metadataAndCertificatesGenerationService;
    private final SamlIdPMetadataLocator samlIdPMetadataLocator;
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    @GetMapping(path={"/idp/metadata"})
    public void generateMetadataForIdp(@RequestParam(value="service", required=false) String service, HttpServletResponse response) throws Throwable {
        Optional<SamlRegisteredService> registeredService = this.getRegisteredServiceIfAny(service);
        this.metadataAndCertificatesGenerationService.generate(registeredService);
        InputStream md = this.samlIdPMetadataLocator.resolveMetadata(registeredService).getInputStream();
        String contents = IOUtils.toString((InputStream)md, (Charset)StandardCharsets.UTF_8);
        response.setContentType(CONTENT_TYPE);
        response.setStatus(200);
        try (PrintWriter writer = response.getWriter();){
            LOGGER.debug("Producing metadata for the response");
            writer.write(contents);
            writer.flush();
        }
    }

    private Optional<SamlRegisteredService> getRegisteredServiceIfAny(String service) {
        if (NumberUtils.isDigits((String)service)) {
            SamlRegisteredService svc = (SamlRegisteredService)this.servicesManager.findServiceBy(Long.parseLong(service), SamlRegisteredService.class);
            return Optional.ofNullable(svc);
        }
        WebApplicationService svc = StringUtils.isNotBlank((CharSequence)service) ? (WebApplicationService)this.webApplicationServiceFactory.createService(service) : null;
        SamlRegisteredService registeredService = (SamlRegisteredService)this.servicesManager.findServiceBy((Service)svc, SamlRegisteredService.class);
        return Optional.ofNullable(registeredService);
    }

    @Generated
    public SamlIdPMetadataController(SamlIdPMetadataGenerator metadataAndCertificatesGenerationService, SamlIdPMetadataLocator samlIdPMetadataLocator, ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
        this.metadataAndCertificatesGenerationService = metadataAndCertificatesGenerationService;
        this.samlIdPMetadataLocator = samlIdPMetadataLocator;
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
    }
}

