/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc;

import com.google.common.collect.Sets;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPAlgorithmsProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPResponseProperties;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataCredentialResolver;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPSamlRegisteredServiceCriterion;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.crypto.CertUtils;
import org.apereo.cas.util.crypto.PrivateKeyFactoryBean;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.impl.SAMLOutboundDestinationHandler;
import org.opensaml.saml.common.binding.security.impl.EndpointURLSchemeSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLOutboundProtocolMessageSigningHandler;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.metadata.criteria.entity.impl.EvaluableEntityRoleEntityDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.security.impl.SAMLMetadataSignatureSigningParametersResolver;
import org.opensaml.security.credential.AbstractCredential;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.MutableCredential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.AlgorithmPolicyConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class DefaultSamlIdPObjectSigner
implements SamlIdPObjectSigner {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSamlIdPObjectSigner.class);
    private final MetadataResolver samlIdPMetadataResolver;
    private final CasConfigurationProperties casProperties;
    private final SamlIdPMetadataLocator samlIdPMetadataLocator;

    private static boolean doesCredentialFingerprintMatch(AbstractCredential credential, SamlRegisteredService samlRegisteredService) {
        String fingerprint = samlRegisteredService.getSigningCredentialFingerprint();
        if (StringUtils.isNotBlank((CharSequence)fingerprint)) {
            String digest = DigestUtils.digest((String)"SHA-1", (byte[])Objects.requireNonNull(credential.getPublicKey()).getEncoded());
            Pattern pattern = RegexUtils.createPattern((String)fingerprint, (int)2);
            LOGGER.debug("Matching credential fingerprint [{}] against filter [{}] for service [{}]", new Object[]{digest, fingerprint, samlRegisteredService.getName()});
            return pattern.matcher(digest).find();
        }
        return true;
    }

    private static AbstractCredential finalizeSigningCredential(MutableCredential credential, Credential original) {
        credential.setEntityId(original.getEntityId());
        credential.setUsageType(original.getUsageType());
        Objects.requireNonNull(original.getCredentialContextSet()).forEach(ctx -> Objects.requireNonNull(credential.getCredentialContextSet()).add(ctx));
        return (AbstractCredential)credential;
    }

    @Override
    public <T extends SAMLObject> T encode(T samlObject, SamlRegisteredService service, SamlRegisteredServiceMetadataAdaptor adaptor, HttpServletResponse response, HttpServletRequest request, String binding, RequestAbstractType authnRequest, MessageContext messageContext) throws Exception {
        LOGGER.trace("Attempting to encode [{}] for [{}]", (Object)samlObject.getClass().getName(), (Object)adaptor.getEntityId());
        this.prepareOutboundContext(samlObject, adaptor, messageContext, binding, authnRequest);
        this.prepareSecurityParametersContext(adaptor, messageContext, service);
        this.prepareEndpointURLSchemeSecurityHandler(messageContext);
        this.prepareSamlOutboundDestinationHandler(messageContext);
        this.prepareSamlOutboundProtocolMessageSigningHandler(messageContext);
        return samlObject;
    }

    protected void prepareSamlOutboundProtocolMessageSigningHandler(MessageContext outboundContext) throws Exception {
        LOGGER.trace("Attempting to sign the outbound SAML message...");
        SAMLOutboundProtocolMessageSigningHandler handler = new SAMLOutboundProtocolMessageSigningHandler();
        handler.setSignErrorResponses(this.casProperties.getAuthn().getSamlIdp().getResponse().isSignError());
        handler.initialize();
        handler.invoke(outboundContext);
        LOGGER.debug("Signed SAML message successfully");
    }

    protected void prepareSamlOutboundDestinationHandler(MessageContext outboundContext) throws Exception {
        SAMLOutboundDestinationHandler handlerDest = new SAMLOutboundDestinationHandler();
        handlerDest.initialize();
        handlerDest.invoke(outboundContext);
    }

    protected void prepareEndpointURLSchemeSecurityHandler(MessageContext outboundContext) throws Exception {
        EndpointURLSchemeSecurityHandler handlerEnd = new EndpointURLSchemeSecurityHandler();
        handlerEnd.initialize();
        handlerEnd.invoke(outboundContext);
    }

    protected void prepareSecurityParametersContext(SamlRegisteredServiceMetadataAdaptor adaptor, MessageContext outboundContext, SamlRegisteredService service) {
        SecurityParametersContext secParametersContext = (SecurityParametersContext)outboundContext.ensureSubcontext(SecurityParametersContext.class);
        SPSSODescriptor roleDesc = adaptor.ssoDescriptor();
        SignatureSigningParameters signingParameters = this.buildSignatureSigningParameters((RoleDescriptor)roleDesc, service);
        Objects.requireNonNull(secParametersContext).setSignatureSigningParameters(signingParameters);
    }

    protected <T extends SAMLObject> void prepareOutboundContext(T samlObject, SamlRegisteredServiceMetadataAdaptor adaptor, MessageContext outboundContext, String binding, RequestAbstractType authnRequest) throws SamlException {
        LOGGER.trace("Outbound saml object to use is [{}]", (Object)samlObject.getClass().getName());
        outboundContext.setMessage(samlObject);
        SamlIdPUtils.preparePeerEntitySamlEndpointContext((Pair)Pair.of((Object)authnRequest, (Object)outboundContext), (MessageContext)outboundContext, (SamlRegisteredServiceMetadataAdaptor)adaptor, (String)binding);
    }

    protected SignatureSigningParameters buildSignatureSigningParameters(RoleDescriptor descriptor, SamlRegisteredService service) {
        return (SignatureSigningParameters)FunctionUtils.doUnchecked(() -> {
            CriteriaSet criteria = new CriteriaSet();
            SignatureSigningConfiguration signatureSigningConfiguration = this.getSignatureSigningConfiguration(service);
            criteria.add((Object)new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{signatureSigningConfiguration}));
            criteria.add((Object)new RoleDescriptorCriterion(descriptor));
            SAMLMetadataSignatureSigningParametersResolver resolver = new SAMLMetadataSignatureSigningParametersResolver();
            LOGGER.trace("Resolving signature signing parameters for [{}]", (Object)descriptor.getElementQName().getLocalPart());
            SignatureSigningParameters params = resolver.resolveSingle(criteria);
            if (params != null) {
                LOGGER.trace("Created signature signing parameters.\nSignature algorithm: [{}]\nSignature canonicalization algorithm: [{}]\nSignature reference digest methods: [{}]\nSignature reference canonicalization algorithm: [{}]", new Object[]{params.getSignatureAlgorithm(), params.getSignatureCanonicalizationAlgorithm(), params.getSignatureReferenceDigestMethod(), params.getSignatureReferenceCanonicalizationAlgorithm()});
            } else {
                LOGGER.warn("Unable to resolve SignatureSigningParameters, response signing will fail. Make sure domain names in IDP metadata URLs and certificates match CAS domain name");
            }
            return params;
        });
    }

    protected SignatureSigningConfiguration getSignatureSigningConfiguration(SamlRegisteredService service) throws Throwable {
        BasicSignatureSigningConfiguration config = this.configureSignatureSigningSecurityConfiguration(service);
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        PrivateKey privateKey = this.getSigningPrivateKey(service);
        SamlIdPMetadataCredentialResolver mdCredentialResolver = new SamlIdPMetadataCredentialResolver();
        RoleDescriptorResolver roleDescriptorResolver = SamlIdPUtils.getRoleDescriptorResolver((MetadataResolver)this.samlIdPMetadataResolver, (boolean)samlIdp.getMetadata().getCore().isRequireValidMetadata());
        mdCredentialResolver.setRoleDescriptorResolver(roleDescriptorResolver);
        mdCredentialResolver.setKeyInfoCredentialResolver(DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
        mdCredentialResolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{config}));
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        CriteriaSet entityIdCriteriaSet = new CriteriaSet(new Criterion[]{new EvaluableEntityRoleEntityDescriptorCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME), new SamlIdPSamlRegisteredServiceCriterion(service)});
        LOGGER.trace("Resolving entity id from SAML2 IdP metadata for signature signing configuration is [{}]", (Object)service.getName());
        String entityId = Objects.requireNonNull((EntityDescriptor)this.samlIdPMetadataResolver.resolveSingle((Object)entityIdCriteriaSet)).getEntityID();
        LOGGER.trace("Resolved entity id from SAML2 IdP metadata is [{}]", (Object)entityId);
        criteriaSet.add((Object)new EntityIdCriterion(entityId));
        criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        criteriaSet.add((Object)new SamlIdPSamlRegisteredServiceCriterion(service));
        LOGGER.trace("Resolved signing credentials based on criteria [{}]", (Object)criteriaSet);
        LinkedHashSet credentials = Sets.newLinkedHashSet((Iterable)mdCredentialResolver.resolve(criteriaSet));
        LOGGER.trace("Resolved [{}] signing credentials", (Object)credentials.size());
        ArrayList finalCredentials = new ArrayList();
        credentials.stream().map(creds -> this.getResolvedSigningCredential((Credential)creds, privateKey, service)).filter(Objects::nonNull).filter(creds -> DefaultSamlIdPObjectSigner.doesCredentialFingerprintMatch(creds, service)).forEach(finalCredentials::add);
        if (finalCredentials.isEmpty()) {
            LOGGER.error("Unable to locate any signing credentials for service [{}]", (Object)service.getName());
            throw new IllegalArgumentException("Unable to locate signing credentials");
        }
        config.setSigningCredentials(finalCredentials);
        LOGGER.trace("Signature signing credentials configured with [{}] credentials", (Object)finalCredentials.size());
        return config;
    }

    protected PrivateKey getSigningPrivateKey(SamlRegisteredService registeredService) throws Throwable {
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        Resource signingKey = this.samlIdPMetadataLocator.resolveSigningKey(Optional.of(registeredService));
        PrivateKeyFactoryBean privateKeyFactoryBean = new PrivateKeyFactoryBean();
        privateKeyFactoryBean.setLocation(signingKey);
        if (StringUtils.isBlank((CharSequence)registeredService.getSigningKeyAlgorithm())) {
            privateKeyFactoryBean.setAlgorithm(samlIdp.getAlgs().getPrivateKeyAlgName());
        } else {
            privateKeyFactoryBean.setAlgorithm(registeredService.getSigningKeyAlgorithm());
        }
        privateKeyFactoryBean.setSingleton(false);
        LOGGER.debug("Locating signature signing key for [{}] using algorithm [{}]", (Object)registeredService.getMetadataLocation(), (Object)privateKeyFactoryBean.getAlgorithm());
        return (PrivateKey)privateKeyFactoryBean.getObject();
    }

    protected BasicSignatureSigningConfiguration configureSignatureSigningSecurityConfiguration(SamlRegisteredService service) {
        List overrideAllowedAlgorithms;
        List overrideBlockedSignatureAlgorithms;
        List overrideSignatureAlgorithms;
        List overrideSignatureReferenceDigestMethods;
        BasicSignatureSigningConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        LOGGER.trace("Default signature signing blocked algorithms: [{}]", (Object)config.getExcludedAlgorithms());
        LOGGER.trace("Default signature signing signature algorithms: [{}]", (Object)config.getSignatureAlgorithms());
        LOGGER.trace("Default signature signing signature canonicalization algorithm: [{}]", (Object)config.getSignatureCanonicalizationAlgorithm());
        LOGGER.trace("Default signature signing allowed algorithms: [{}]", (Object)config.getIncludedAlgorithms());
        LOGGER.trace("Default signature signing reference digest methods: [{}]", (Object)config.getSignatureReferenceDigestMethods());
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        SamlIdPAlgorithmsProperties globalAlgorithms = samlIdp.getAlgs();
        List list = overrideSignatureReferenceDigestMethods = service.getSigningSignatureReferenceDigestMethods().isEmpty() ? globalAlgorithms.getOverrideSignatureReferenceDigestMethods() : service.getSigningSignatureReferenceDigestMethods();
        if (overrideSignatureReferenceDigestMethods != null && !overrideSignatureReferenceDigestMethods.isEmpty()) {
            config.setSignatureReferenceDigestMethods(overrideSignatureReferenceDigestMethods);
        }
        List list2 = overrideSignatureAlgorithms = service.getSigningSignatureAlgorithms().isEmpty() ? globalAlgorithms.getOverrideSignatureAlgorithms() : service.getSigningSignatureAlgorithms();
        if (overrideSignatureAlgorithms != null && !overrideSignatureAlgorithms.isEmpty()) {
            config.setSignatureAlgorithms(overrideSignatureAlgorithms);
        }
        List list3 = overrideBlockedSignatureAlgorithms = service.getSigningSignatureBlackListedAlgorithms().isEmpty() ? globalAlgorithms.getOverrideBlockedSignatureSigningAlgorithms() : service.getSigningSignatureBlackListedAlgorithms();
        if (overrideBlockedSignatureAlgorithms != null && !overrideBlockedSignatureAlgorithms.isEmpty()) {
            config.setExcludedAlgorithms((Collection)overrideBlockedSignatureAlgorithms);
        }
        List list4 = overrideAllowedAlgorithms = service.getSigningSignatureWhiteListedAlgorithms().isEmpty() ? globalAlgorithms.getOverrideAllowedSignatureSigningAlgorithms() : service.getSigningSignatureWhiteListedAlgorithms();
        if (overrideAllowedAlgorithms != null && !overrideAllowedAlgorithms.isEmpty()) {
            config.setIncludedAlgorithms((Collection)overrideAllowedAlgorithms);
        }
        if (StringUtils.isNotBlank((CharSequence)service.getSigningSignatureCanonicalizationAlgorithm())) {
            config.setSignatureCanonicalizationAlgorithm(service.getSigningSignatureCanonicalizationAlgorithm());
        } else if (StringUtils.isNotBlank((CharSequence)globalAlgorithms.getOverrideSignatureCanonicalizationAlgorithm())) {
            config.setSignatureCanonicalizationAlgorithm(globalAlgorithms.getOverrideSignatureCanonicalizationAlgorithm());
        }
        LOGGER.trace("Finalized signature signing blocked algorithms: [{}]", (Object)config.getExcludedAlgorithms());
        LOGGER.trace("Finalized signature signing signature algorithms: [{}]", (Object)config.getSignatureAlgorithms());
        LOGGER.trace("Finalized signature signing signature canonicalization algorithm: [{}]", (Object)config.getSignatureCanonicalizationAlgorithm());
        LOGGER.trace("Finalized signature signing allowed algorithms: [{}]", (Object)config.getIncludedAlgorithms());
        LOGGER.trace("Finalized signature signing reference digest methods: [{}]", (Object)config.getSignatureReferenceDigestMethods());
        if (StringUtils.isNotBlank((CharSequence)service.getWhiteListBlackListPrecedence())) {
            AlgorithmPolicyConfiguration.Precedence precedence = AlgorithmPolicyConfiguration.Precedence.valueOf((String)service.getWhiteListBlackListPrecedence().trim().toUpperCase(Locale.ENGLISH));
            config.setIncludeExcludePrecedence(precedence);
        }
        return config;
    }

    protected AbstractCredential getResolvedSigningCredential(Credential credential, PrivateKey privateKey, SamlRegisteredService service) {
        try {
            SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
            SamlIdPResponseProperties.SignatureCredentialTypes credType = SamlIdPResponseProperties.SignatureCredentialTypes.valueOf((String)((String)StringUtils.defaultIfBlank((CharSequence)service.getSigningCredentialType(), (CharSequence)samlIdp.getResponse().getCredentialType().name())).toUpperCase(Locale.ENGLISH));
            LOGGER.trace("Requested credential type [{}] is found for service [{}]", (Object)credType, (Object)service.getName());
            switch (credType) {
                case BASIC: {
                    LOGGER.debug("Building credential signing key [{}] based on requested credential type", (Object)credType);
                    if (credential.getPublicKey() == null) {
                        throw new IllegalArgumentException("Unable to identify the public key from the signing credential");
                    }
                    return DefaultSamlIdPObjectSigner.finalizeSigningCredential((MutableCredential)new BasicCredential(credential.getPublicKey(), privateKey), credential);
                }
                case X509: {
                    if (credential instanceof BasicX509Credential) {
                        BasicX509Credential value = (BasicX509Credential)credential;
                        X509Certificate certificate = value.getEntityCertificate();
                        LOGGER.debug("Locating signature signing certificate from credential [{}]", (Object)CertUtils.toString((X509Certificate)certificate));
                        return DefaultSamlIdPObjectSigner.finalizeSigningCredential((MutableCredential)new BasicX509Credential(certificate, privateKey), credential);
                    }
                    Resource signingCert = this.samlIdPMetadataLocator.resolveSigningCertificate(Optional.of(service));
                    LOGGER.debug("Locating signature signing certificate file from [{}]", (Object)signingCert);
                    X509Certificate certificate = SamlUtils.readCertificate((Resource)signingCert);
                    return DefaultSamlIdPObjectSigner.finalizeSigningCredential((MutableCredential)new BasicX509Credential(certificate, privateKey), credential);
                }
            }
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return null;
    }

    @Generated
    public DefaultSamlIdPObjectSigner(MetadataResolver samlIdPMetadataResolver, CasConfigurationProperties casProperties, SamlIdPMetadataLocator samlIdPMetadataLocator) {
        this.samlIdPMetadataResolver = samlIdPMetadataResolver;
        this.casProperties = casProperties;
        this.samlIdPMetadataLocator = samlIdPMetadataLocator;
    }

    @Override
    @Generated
    public MetadataResolver getSamlIdPMetadataResolver() {
        return this.samlIdPMetadataResolver;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public SamlIdPMetadataLocator getSamlIdPMetadataLocator() {
        return this.samlIdPMetadataLocator;
    }
}

