/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.sso;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.ScratchContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.BindingCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPPostEncoder;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Endpoint(id="samlPostProfileResponse", enableByDefault=false)
public class SSOSamlIdPPostProfileHandlerEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOSamlIdPPostProfileHandlerEndpoint.class);
    private final ServicesManager servicesManager;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final ServiceFactory<WebApplicationService> serviceFactory;
    private final PrincipalFactory principalFactory;
    private final SamlProfileObjectBuilder<? extends SAMLObject> responseBuilder;
    private final SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver;
    private final AbstractSaml20ObjectBuilder saml20ObjectBuilder;
    private final PrincipalResolver principalResolver;
    private final MetadataResolver samlIdPMetadataResolver;

    public SSOSamlIdPPostProfileHandlerEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ServicesManager servicesManager, AuthenticationSystemSupport authenticationSystemSupport, ServiceFactory<WebApplicationService> serviceFactory, PrincipalFactory principalFactory, SamlProfileObjectBuilder<? extends SAMLObject> responseBuilder, SamlRegisteredServiceCachingMetadataResolver cachingMetadataResolver, AbstractSaml20ObjectBuilder saml20ObjectBuilder, PrincipalResolver principalResolver, MetadataResolver samlIdPMetadataResolver) {
        super(casProperties, applicationContext);
        this.servicesManager = servicesManager;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.serviceFactory = serviceFactory;
        this.principalFactory = principalFactory;
        this.responseBuilder = responseBuilder;
        this.defaultSamlRegisteredServiceCachingMetadataResolver = cachingMetadataResolver;
        this.saml20ObjectBuilder = saml20ObjectBuilder;
        this.principalResolver = principalResolver;
        this.samlIdPMetadataResolver = samlIdPMetadataResolver;
    }

    @PostMapping(produces={"application/xml"})
    @ResponseBody
    @Operation(summary="Produce SAML2 response entity", parameters={@Parameter(name="username", required=true, description="The username to authenticate"), @Parameter(name="password", required=false, description="The password to authenticate"), @Parameter(name="entityId", required=true, description="The entity id"), @Parameter(name="encrypt", schema=@Schema(type="boolean"), description="Whether to encrypt the response")})
    public ResponseEntity<Object> producePost(HttpServletRequest request, HttpServletResponse response, @ModelAttribute SamlRequest samlRequest) {
        return this.produce(request, response, samlRequest);
    }

    @PostMapping(value={"/logout/post"}, produces={"text/html"})
    @Operation(summary="Produce SAML2 logout request for the given SAML2 SP", parameters={@Parameter(name="entityId", required=true, description="The entity id")})
    public ResponseEntity<Object> produceLogoutRequestPost(@RequestParam(value="entityId") String entityId, HttpServletResponse response) throws Exception {
        WebApplicationService selectedService = (WebApplicationService)this.serviceFactory.createService(entityId);
        SamlRegisteredService registeredService = (SamlRegisteredService)this.servicesManager.findServiceBy((Service)selectedService, SamlRegisteredService.class);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)selectedService, (RegisteredService)registeredService);
        LogoutRequest logoutRequest = (LogoutRequest)this.saml20ObjectBuilder.newSamlObject(LogoutRequest.class);
        logoutRequest.setID(RandomUtils.randomAlphabetic((int)4));
        Issuer issuer = (Issuer)this.saml20ObjectBuilder.newSamlObject(Issuer.class);
        issuer.setValue(entityId);
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIdCriterion(this.casProperties.getAuthn().getSamlIdp().getCore().getEntityId()));
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        criteriaSet.add((Object)new BindingCriterion(List.of("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")));
        EntityDescriptor result = (EntityDescriptor)this.samlIdPMetadataResolver.resolveSingle((Object)criteriaSet);
        String sloEndpointDestination = result.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getEndpoints(SingleLogoutService.DEFAULT_ELEMENT_NAME).stream().filter(endpoint -> "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(endpoint.getBinding())).findFirst().orElseThrow().getLocation();
        NameID nameId = (NameID)this.saml20ObjectBuilder.newSamlObject(NameID.class);
        nameId.setValue(UUID.randomUUID().toString());
        logoutRequest.setNameID(nameId);
        logoutRequest.setIssuer(issuer);
        logoutRequest.setDestination(sloEndpointDestination);
        logoutRequest.setIssueInstant(Instant.now(Clock.systemUTC()).minusSeconds(10L));
        HTTPPostEncoder encoder = new HTTPPostEncoder();
        encoder.setVelocityEngine(this.saml20ObjectBuilder.getOpenSamlConfigBean().getVelocityEngine());
        encoder.setHttpServletResponseSupplier(() -> response);
        MessageContext messageContext = new MessageContext();
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)UUID.randomUUID().toString());
        SAMLPeerEntityContext peerEntityContext = (SAMLPeerEntityContext)messageContext.ensureSubcontext(SAMLPeerEntityContext.class);
        SAMLEndpointContext endpointContext = (SAMLEndpointContext)peerEntityContext.ensureSubcontext(SAMLEndpointContext.class);
        SingleSignOnService endpoint2 = (SingleSignOnService)this.saml20ObjectBuilder.newSamlObject(SingleSignOnService.class);
        endpoint2.setLocation(sloEndpointDestination);
        endpointContext.setEndpoint((org.opensaml.saml.saml2.metadata.Endpoint)endpoint2);
        messageContext.setMessage((Object)logoutRequest);
        encoder.setMessageContext(messageContext);
        encoder.initialize();
        encoder.encode();
        return ResponseEntity.ok().build();
    }

    private ResponseEntity<Object> produce(HttpServletRequest request, HttpServletResponse response, SamlRequest samlRequest) {
        try {
            WebApplicationService selectedService = (WebApplicationService)this.serviceFactory.createService(samlRequest.getEntityId());
            SamlRegisteredService registeredService = (SamlRegisteredService)this.servicesManager.findServiceBy((Service)selectedService, SamlRegisteredService.class);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)selectedService, (RegisteredService)registeredService);
            SamlRegisteredService loadedService = (SamlRegisteredService)BeanUtils.cloneBean((Object)registeredService);
            loadedService.setEncryptAssertions(samlRequest.isEncrypt());
            loadedService.setEncryptAttributes(samlRequest.isEncrypt());
            AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject();
            authnRequest.setIssuer(this.saml20ObjectBuilder.newIssuer(samlRequest.getEntityId()));
            Optional result = SamlRegisteredServiceMetadataAdaptor.get((SamlRegisteredServiceCachingMetadataResolver)this.defaultSamlRegisteredServiceCachingMetadataResolver, (SamlRegisteredService)loadedService, (String)samlRequest.getEntityId());
            return (ResponseEntity)result.map(Unchecked.function(adaptor -> {
                MessageContext messageContext = new MessageContext();
                ScratchContext scratch = (ScratchContext)messageContext.ensureSubcontext(ScratchContext.class);
                Map map = Objects.requireNonNull(scratch).getMap();
                map.put("encodeSamlResponse", Boolean.FALSE);
                AuthenticatedAssertionContext assertion = this.getAssertion(samlRequest);
                Object buildContext = ((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)SamlProfileBuilderContext.builder().samlRequest((RequestAbstractType)authnRequest)).httpRequest(request)).httpResponse(response)).authenticatedAssertion(Optional.of(assertion))).registeredService(loadedService)).adaptor((SamlRegisteredServiceMetadataAdaptor)adaptor)).binding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")).messageContext(messageContext)).build();
                SAMLObject object = this.responseBuilder.build((SamlProfileBuilderContext)buildContext);
                String encoded = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.saml20ObjectBuilder.getOpenSamlConfigBean(), (XMLObject)object, (boolean)true).toString();
                return new ResponseEntity((Object)encoded, (HttpStatusCode)HttpStatus.OK);
            })).orElseThrow(() -> new SamlException("Unable to locate " + samlRequest.getEntityId()));
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return new ResponseEntity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    private AuthenticatedAssertionContext getAssertion(SamlRequest samlRequest) throws Throwable {
        WebApplicationService selectedService = (WebApplicationService)this.serviceFactory.createService(samlRequest.getEntityId());
        SamlRegisteredService registeredService = (SamlRegisteredService)this.servicesManager.findServiceBy((Service)selectedService, SamlRegisteredService.class);
        Authentication authentication = this.authenticateRequest(samlRequest, selectedService);
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)registeredService).applicationContext((ApplicationContext)this.saml20ObjectBuilder.getOpenSamlConfigBean().getApplicationContext()).service((Service)selectedService).principal(authentication.getPrincipal()).build();
        Map attributesToRelease = registeredService.getAttributeReleasePolicy().getAttributes(context);
        AuthenticationBuilder builder = DefaultAuthenticationBuilder.of((ApplicationContext)context.getApplicationContext(), (Principal)authentication.getPrincipal(), (PrincipalFactory)this.principalFactory, (Map)attributesToRelease, (Service)selectedService, (RegisteredService)registeredService, (Authentication)authentication);
        Authentication finalAuthentication = builder.build();
        Principal authnPrincipal = finalAuthentication.getPrincipal();
        return ((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)AuthenticatedAssertionContext.builder().name(authnPrincipal.getId())).attributes(CollectionUtils.merge((Map[])new Map[]{authnPrincipal.getAttributes(), finalAuthentication.getAttributes()}))).build();
    }

    private Authentication authenticateRequest(SamlRequest samlRequest, WebApplicationService selectedService) throws Throwable {
        if (StringUtils.isNotBlank((CharSequence)samlRequest.getPassword())) {
            UsernamePasswordCredential credential = new UsernamePasswordCredential(samlRequest.getUsername(), samlRequest.getPassword());
            AuthenticationResult result = this.authenticationSystemSupport.finalizeAuthenticationTransaction((Service)selectedService, new Credential[]{credential});
            return result.getAuthentication();
        }
        Principal principal = this.principalResolver.resolve((Credential)new BasicIdentifiableCredential(samlRequest.getUsername()), Optional.of(this.principalFactory.createPrincipal(samlRequest.getUsername())), Optional.empty(), Optional.of(selectedService));
        return DefaultAuthenticationBuilder.newInstance().setPrincipal(principal).build();
    }

    public static class SamlRequest
    implements Serializable {
        private static final long serialVersionUID = 9132411807103771828L;
        private String username;
        private String password;
        private String entityId;
        private boolean encrypt;

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public String getEntityId() {
            return this.entityId;
        }

        @Generated
        public boolean isEncrypt() {
            return this.encrypt;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Generated
        public void setEncrypt(boolean encrypt) {
            this.encrypt = encrypt;
        }

        @Generated
        public SamlRequest(String username, String password, String entityId, boolean encrypt) {
            this.username = username;
            this.password = password;
            this.entityId = entityId;
            this.encrypt = encrypt;
        }

        @Generated
        public SamlRequest() {
        }

        @Generated
        public SamlRequest withUsername(String username) {
            return this.username == username ? this : new SamlRequest(username, this.password, this.entityId, this.encrypt);
        }

        @Generated
        public SamlRequest withPassword(String password) {
            return this.password == password ? this : new SamlRequest(this.username, password, this.entityId, this.encrypt);
        }

        @Generated
        public SamlRequest withEntityId(String entityId) {
            return this.entityId == entityId ? this : new SamlRequest(this.username, this.password, entityId, this.encrypt);
        }

        @Generated
        public SamlRequest withEncrypt(boolean encrypt) {
            return this.encrypt == encrypt ? this : new SamlRequest(this.username, this.password, this.entityId, encrypt);
        }
    }
}

