/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.metadata;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.CachedMetadataResolverResult;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.criterion.SatisfyAnyCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.criteria.entity.impl.EvaluableEntityRoleEntityDescriptorCriterion;
import org.opensaml.saml.saml2.common.TimeBoundSAMLObject;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Endpoint(id="samlIdPRegisteredServiceMetadataCache", enableByDefault=false)
public class SamlRegisteredServiceCachedMetadataEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceCachedMetadataEndpoint.class);
    private final ObjectProvider<SamlRegisteredServiceCachingMetadataResolver> cachingMetadataResolver;
    private final ObjectProvider<ServicesManager> servicesManager;
    private final ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    private final ObjectProvider<OpenSamlConfigBean> openSamlConfigBean;

    public SamlRegisteredServiceCachedMetadataEndpoint(CasConfigurationProperties casProperties, ObjectProvider<SamlRegisteredServiceCachingMetadataResolver> cachingMetadataResolver, ObjectProvider<ServicesManager> servicesManager, ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer, ObjectProvider<OpenSamlConfigBean> openSamlConfigBean) {
        super(casProperties, ((OpenSamlConfigBean)openSamlConfigBean.getObject()).getApplicationContext());
        this.cachingMetadataResolver = cachingMetadataResolver;
        this.servicesManager = servicesManager;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.openSamlConfigBean = openSamlConfigBean;
    }

    @DeleteMapping
    @Operation(summary="Invalidate SAML2 metadata cache using a service id or entity id. The service id could be the registered service numeric identifier, its name or actual service id. In case the service definition points to an aggregate, you may also specify an entity id to locate the service provider within that aggregate. If you do not specify any parameters, all entries in the metadata cache will be invalidated.", parameters={@Parameter(name="serviceId", description="The service id"), @Parameter(name="entityId", description="The entity id")})
    public ResponseEntity invalidate(@Nullable @RequestParam(required=false) String serviceId, @Nullable @RequestParam(required=false) String entityId) throws Throwable {
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            ((SamlRegisteredServiceCachingMetadataResolver)this.cachingMetadataResolver.getObject()).invalidate();
            LOGGER.info("Cleared SAML2 registered service metadata cache");
            return ResponseEntity.noContent().build();
        }
        SamlRegisteredService registeredService = this.findRegisteredService(serviceId);
        CriteriaSet criteriaSet = new CriteriaSet();
        String effectiveEntityId = (String)StringUtils.defaultIfBlank((CharSequence)entityId, (CharSequence)registeredService.getServiceId());
        criteriaSet.add((Object)new EntityIdCriterion(effectiveEntityId));
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        ((SamlRegisteredServiceCachingMetadataResolver)this.cachingMetadataResolver.getObject()).invalidate(registeredService, criteriaSet);
        LOGGER.info("Invalidated SAML2 registered service metadata cache entry for [{}]", (Object)registeredService);
        return ResponseEntity.noContent().header(registeredService.getClass().getSimpleName(), new String[]{String.valueOf(registeredService.getId()), registeredService.getName()}).header(EntityIdCriterion.class.getSimpleName(), new String[]{effectiveEntityId}).build();
    }

    @GetMapping(produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml"})
    @Operation(summary="Get SAML2 cached metadata for a SAML2 registered service. The service id could be the registered service numeric identifier, its name or actual service id. In case the service definition points to an aggregate, you may also specify an entity id to locate the service provider within that aggregate", parameters={@Parameter(name="serviceId", required=true, description="The service id"), @Parameter(name="entityId", description="The entity id")})
    public ResponseEntity<? extends Map> getCachedMetadataObject(@RequestParam String serviceId, @Nullable @RequestParam(required=false) String entityId, @RequestParam(required=false, defaultValue="true") boolean force) {
        return (ResponseEntity)FunctionUtils.doAndHandle(() -> {
            SamlRegisteredService registeredService = this.findRegisteredService(serviceId);
            CriteriaSet criteriaSet = new CriteriaSet();
            if (StringUtils.isNotBlank((CharSequence)entityId)) {
                criteriaSet.add((Object)new EntityIdCriterion(entityId));
                criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
            } else {
                criteriaSet.add((Object)new EvaluableEntityRoleEntityDescriptorCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
                criteriaSet.add((Object)new SatisfyAnyCriterion(true));
            }
            Optional<CachedMetadataResolverResult> metadataResolverResult = force ? Optional.of(((SamlRegisteredServiceCachingMetadataResolver)this.cachingMetadataResolver.getObject()).resolve(registeredService, criteriaSet)) : ((SamlRegisteredServiceCachingMetadataResolver)this.cachingMetadataResolver.getObject()).getIfPresent(registeredService, criteriaSet);
            return (ResponseEntity)metadataResolverResult.map(Unchecked.function(result -> {
                Spliterator iteration = result.getMetadataResolver().resolve((Object)criteriaSet).spliterator();
                Map<String, Map> body = StreamSupport.stream(iteration, false).filter(TimeBoundSAMLObject::isValid).map(entity -> {
                    Map details = CollectionUtils.wrap((String)"cachedInstant", (Object)result.getCachedInstant(), (String)"metadata", (Object)SamlUtils.transformSamlObject((OpenSamlConfigBean)((OpenSamlConfigBean)this.openSamlConfigBean.getObject()), (XMLObject)entity).toString());
                    return Pair.of((Object)entity.getEntityID(), (Object)details);
                }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
                return ResponseEntity.ok(body);
            })).orElseThrow(() -> new SamlException("Unable to locate and resolve metadata for service " + registeredService.getName()));
        }, e -> ResponseEntity.badRequest().body(Map.of("error", e.getMessage()))).get();
    }

    protected SamlRegisteredService findRegisteredService(String serviceId) throws Throwable {
        List matchedServices = null;
        if (NumberUtils.isCreatable((String)serviceId)) {
            long id = Long.parseLong(serviceId);
            SamlRegisteredService samlService = (SamlRegisteredService)((ServicesManager)this.servicesManager.getObject()).findServiceBy(id, SamlRegisteredService.class);
            matchedServices = samlService != null ? List.of(samlService) : List.of();
        } else {
            matchedServices = ((ServicesManager)this.servicesManager.getObject()).findServiceBy(svc -> svc instanceof SamlRegisteredService && (svc.getName().equalsIgnoreCase(serviceId) || svc.getServiceId().equalsIgnoreCase(serviceId)));
        }
        if (matchedServices.isEmpty()) {
            throw UnauthorizedServiceException.denied((String)("Unable to locate service " + serviceId));
        }
        SamlRegisteredService registeredService = (SamlRegisteredService)matchedServices.iterator().next();
        AuditableContext ctx = AuditableContext.builder().registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult result = ((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).execute(ctx);
        result.throwExceptionIfNeeded();
        LOGGER.debug("Located registered service definition [{}]", (Object)registeredService);
        return registeredService;
    }
}

