/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.attr;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.attribute.AttributeDefinition;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPResponseProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.util.Saml20AttributeBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlIdPAttributeDefinition;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlProfileSamlRegisteredServiceAttributeBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SamlProfileSamlAttributeStatementBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<AttributeStatement> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlAttributeStatementBuilder.class);
    private static final long serialVersionUID = 1815697787562189088L;
    private final SamlIdPProperties samlIdPProperties;
    private final SamlIdPObjectEncrypter samlObjectEncrypter;
    private final AttributeDefinitionStore attributeDefinitionStore;
    private final ServiceFactory<WebApplicationService> serviceFactory;
    private final SamlProfileObjectBuilder<SAMLObject> samlNameIdBuilder;
    private final MetadataResolver samlIdPMetadataResolver;

    public SamlProfileSamlAttributeStatementBuilder(OpenSamlConfigBean configBean, SamlIdPProperties samlIdPProperties, SamlIdPObjectEncrypter samlObjectEncrypter, AttributeDefinitionStore attributeDefinitionStore, ServiceFactory<WebApplicationService> serviceFactory, SamlProfileObjectBuilder<SAMLObject> samlNameIdBuilder, MetadataResolver samlIdPMetadataResolver) {
        super(configBean);
        this.samlIdPProperties = samlIdPProperties;
        this.samlObjectEncrypter = samlObjectEncrypter;
        this.attributeDefinitionStore = attributeDefinitionStore;
        this.serviceFactory = serviceFactory;
        this.samlNameIdBuilder = samlNameIdBuilder;
        this.samlIdPMetadataResolver = samlIdPMetadataResolver;
    }

    @Override
    public AttributeStatement build(SamlProfileBuilderContext context) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>(context.getAuthenticatedAssertion().get().getAttributes());
        WebApplicationService webApplicationService = (WebApplicationService)this.serviceFactory.createService(context.getAdaptor().getEntityId(), WebApplicationService.class);
        Map encodedAttrs = ProtocolAttributeEncoder.decodeAttributes(attributes, (RegisteredService)context.getRegisteredService(), (WebApplicationService)webApplicationService);
        SamlProfileSamlRegisteredServiceAttributeBuilder attrBuilder = new SamlProfileSamlRegisteredServiceAttributeBuilder(context.getRegisteredService(), context.getAdaptor(), this.samlObjectEncrypter);
        return this.newAttributeStatement(context, encodedAttrs, (Saml20AttributeBuilder)attrBuilder);
    }

    private String getAttributeFriendlyName(SamlProfileBuilderContext context, String name) {
        if (context.getRegisteredService().getAttributeFriendlyNames().containsKey(name)) {
            return (String)context.getRegisteredService().getAttributeFriendlyNames().get(name);
        }
        return this.attributeDefinitionStore.getAttributeDefinitionsBy(SamlIdPAttributeDefinition.class).filter(defn -> org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)defn.getKey()) || org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)defn.getName()) || org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)defn.getUrn())).findFirst().map(SamlIdPAttributeDefinition::getFriendlyName).filter(org.apache.commons.lang3.StringUtils::isNotBlank).stream().findFirst().or(() -> {
            List globalFriendlyNames = this.samlIdPProperties.getCore().getAttributeFriendlyNames();
            HashMap friendlyNames = new HashMap(CollectionUtils.convertDirectedListToMap((Collection)globalFriendlyNames));
            return Optional.ofNullable((String)friendlyNames.get(name));
        }).orElse(name);
    }

    public AttributeStatement newAttributeStatement(SamlProfileBuilderContext context, Map<String, Object> attributes, Saml20AttributeBuilder builder) throws Exception {
        AttributeStatement attrStatement = (AttributeStatement)SamlUtils.newSamlObject(AttributeStatement.class);
        SamlIdPResponseProperties resp = this.samlIdPProperties.getResponse();
        HashMap nameFormats = new HashMap(resp.configureAttributeNameFormats());
        nameFormats.putAll(context.getRegisteredService().getAttributeNameFormats());
        HashMap urns = new HashMap();
        this.attributeDefinitionStore.getAttributeDefinitions().stream().filter(SamlIdPAttributeDefinition.class::isInstance).map(SamlIdPAttributeDefinition.class::cast).filter(defn -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)defn.getUrn())).forEach(defn -> {
            urns.put(defn.getKey(), defn.getUrn());
            urns.put(defn.getName(), defn.getUrn());
        });
        LOGGER.debug("Attribute definitions tagged with URNs in the attribute definition store are [{}]", urns);
        LOGGER.debug("Attributes to process for SAML2 attribute statement are [{}]", attributes);
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Object attributeValue = entry.getValue();
            if (attributeValue instanceof Collection && ((Collection)attributeValue).isEmpty()) {
                LOGGER.info("Skipping attribute [{}] because it does not have any values.", (Object)entry.getKey());
                continue;
            }
            String friendlyName = this.getAttributeFriendlyName(context, entry.getKey());
            Collection<String> attributeNames = urns.containsKey(entry.getKey()) ? List.of((String)urns.get(entry.getKey())) : this.getMappedAttributeNamesFromAttributeDefinitionStore(entry);
            for (String name : attributeNames) {
                SAMLObject nameIdObject;
                LOGGER.trace("Processing SAML attribute [{}] with value [{}], friendlyName [{}]", new Object[]{name, attributeValue, friendlyName});
                String valueType = (String)context.getRegisteredService().getAttributeValueTypes().get(name);
                if (NameIDType.class.getSimpleName().equalsIgnoreCase(valueType) && (nameIdObject = this.samlNameIdBuilder.build(context)) instanceof NameID) {
                    NameID nameId = (NameID)nameIdObject;
                    NameID nameID = (NameID)this.newSamlObject(NameID.class);
                    nameID.setFormat(nameId.getFormat());
                    nameID.setNameQualifier(nameId.getNameQualifier());
                    nameID.setSPNameQualifier(nameId.getSPNameQualifier());
                    nameID.setValue(nameId.getValue());
                    attributeValue = nameID;
                }
                if ("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent".equalsIgnoreCase(valueType)) {
                    NameID nameID = (NameID)this.newSamlObject(NameID.class);
                    nameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
                    nameID.setNameQualifier(SamlIdPUtils.determineNameIdNameQualifier((SamlRegisteredService)context.getRegisteredService(), (MetadataResolver)this.samlIdPMetadataResolver));
                    FunctionUtils.doIf((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)context.getRegisteredService().getServiceProviderNameIdQualifier()), value -> nameID.setSPNameQualifier(context.getRegisteredService().getServiceProviderNameIdQualifier()), value -> nameID.setSPNameQualifier(context.getAdaptor().getEntityId())).accept(context.getRegisteredService());
                    CollectionUtils.firstElement((Object)attributeValue).ifPresent(value -> nameID.setValue(value.toString()));
                    attributeValue = nameID;
                }
                LOGGER.debug("Creating SAML attribute [{}] with value [{}], friendlyName [{}]", new Object[]{name, attributeValue, friendlyName});
                Attribute attribute = this.newAttribute(friendlyName, name, attributeValue, nameFormats, resp.getDefaultAttributeNameFormat(), context.getRegisteredService().getAttributeValueTypes());
                LOGGER.trace("Created SAML attribute [{}] with NameID format [{}]", (Object)attribute.getName(), (Object)attribute.getNameFormat());
                builder.build(attrStatement, attribute);
            }
        }
        return attrStatement;
    }

    protected Collection<String> getMappedAttributeNamesFromAttributeDefinitionStore(Map.Entry<String, Object> entry) {
        return StringUtils.commaDelimitedListToSet((String)this.attributeDefinitionStore.locateAttributeDefinition(entry.getKey()).map(AttributeDefinition::getName).filter(org.apache.commons.lang3.StringUtils::isNotBlank).orElseGet(entry::getKey));
    }
}

