/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.IdPInitiatedProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.artifact.Saml1ArtifactResolutionProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.BaseSamlObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSignatureValidator;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlObjectSignatureValidator;
import org.apereo.cas.support.saml.web.idp.profile.ecp.ECPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.query.Saml2AttributeQueryProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.slo.SLOSamlPostProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.slo.SLOSamlRedirectProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlPostProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlPostSimpleSignProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlProfileCallbackHandlerController;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.ecp.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="samlIdPEndpointsConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlIdPEndpointsConfiguration {
    @Autowired
    @Qualifier(value="casClientTicketValidator")
    private AbstractUrlBasedTicketValidator casClientTicketValidator;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="noRedirectHttpClient")
    private HttpClient httpClient;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private OpenSamlConfigBean openSamlConfigBean;
    @Autowired
    @Qualifier(value="samlProfileSamlResponseBuilder")
    private SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlResponseBuilder;
    @Autowired
    @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver")
    private SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="samlObjectSigner")
    private BaseSamlObjectSigner samlObjectSigner;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="casSamlIdPMetadataResolver")
    private MetadataResolver casSamlIdPMetadataResolver;
    @Autowired
    @Qualifier(value="samlProfileSamlSoap11ResponseBuilder")
    private SamlProfileObjectBuilder<Response> samlProfileSamlSoap11ResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlSoap11FaultResponseBuilder")
    private SamlProfileObjectBuilder<Response> samlProfileSamlSoap11FaultResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlArtifactResponseBuilder")
    private SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlArtifactResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlArtifactFaultResponseBuilder")
    private SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlArtifactFaultResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlAttributeQueryResponseBuilder")
    private SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlAttributeQueryResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlAttributeQueryFaultResponseBuilder")
    private SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlAttributeQueryFaultResponseBuilder;
    @Autowired
    @Qualifier(value="samlAttributeQueryTicketFactory")
    private SamlAttributeQueryTicketFactory samlAttributeQueryTicketFactory;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;

    @ConditionalOnMissingBean(name={"samlIdPObjectSignatureValidator"})
    @Bean
    public SamlObjectSignatureValidator samlIdPObjectSignatureValidator() {
        SamlIdPProperties.Algorithms algs = this.casProperties.getAuthn().getSamlIdp().getAlgs();
        return new SamlIdPObjectSignatureValidator(algs.getOverrideSignatureReferenceDigestMethods(), algs.getOverrideSignatureAlgorithms(), algs.getOverrideBlackListedSignatureSigningAlgorithms(), algs.getOverrideWhiteListedSignatureSigningAlgorithms(), this.casSamlIdPMetadataResolver);
    }

    @ConditionalOnMissingBean(name={"samlObjectSignatureValidator"})
    @Bean
    public SamlObjectSignatureValidator samlObjectSignatureValidator() {
        SamlIdPProperties.Algorithms algs = this.casProperties.getAuthn().getSamlIdp().getAlgs();
        return new SamlObjectSignatureValidator(algs.getOverrideSignatureReferenceDigestMethods(), algs.getOverrideSignatureAlgorithms(), algs.getOverrideBlackListedSignatureSigningAlgorithms(), algs.getOverrideWhiteListedSignatureSigningAlgorithms());
    }

    @Bean
    @RefreshScope
    public SSOSamlPostProfileHandlerController ssoPostProfileHandlerController() {
        return new SSOSamlPostProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlResponseBuilder, this.casProperties, this.samlObjectSignatureValidator());
    }

    @Bean
    @RefreshScope
    public SSOSamlPostSimpleSignProfileHandlerController ssoPostSimpleSignProfileHandlerController() {
        return new SSOSamlPostSimpleSignProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlResponseBuilder, this.casProperties, this.samlObjectSignatureValidator());
    }

    @Bean
    @RefreshScope
    public SLOSamlRedirectProfileHandlerController sloRedirectProfileHandlerController() {
        return new SLOSamlRedirectProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlResponseBuilder, this.casProperties, this.samlObjectSignatureValidator());
    }

    @Bean
    @RefreshScope
    public SLOSamlPostProfileHandlerController sloPostProfileHandlerController() {
        return new SLOSamlPostProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlResponseBuilder, this.casProperties, this.samlObjectSignatureValidator());
    }

    @Bean
    @RefreshScope
    public IdPInitiatedProfileHandlerController idPInitiatedSamlProfileHandlerController() {
        return new IdPInitiatedProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlResponseBuilder, this.casProperties, this.samlIdPObjectSignatureValidator());
    }

    @Bean
    @RefreshScope
    public SSOSamlProfileCallbackHandlerController ssoPostProfileCallbackHandlerController() {
        return new SSOSamlProfileCallbackHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlResponseBuilder, this.casProperties, this.samlObjectSignatureValidator(), this.casClientTicketValidator);
    }

    @Bean
    @RefreshScope
    public ECPProfileHandlerController ecpProfileHandlerController() {
        return new ECPProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlSoap11ResponseBuilder, this.samlProfileSamlSoap11FaultResponseBuilder, this.casProperties, this.samlObjectSignatureValidator());
    }

    @Autowired
    @Bean
    @RefreshScope
    public Saml1ArtifactResolutionProfileHandlerController saml1ArtifactResolutionController(@Qualifier(value="samlArtifactTicketFactory") SamlArtifactTicketFactory samlArtifactTicketFactory) {
        return new Saml1ArtifactResolutionProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlArtifactResponseBuilder, this.casProperties, this.samlObjectSignatureValidator(), this.ticketRegistry, samlArtifactTicketFactory, this.samlProfileSamlArtifactFaultResponseBuilder);
    }

    @ConditionalOnProperty(prefix="cas.authn.samlIdp", name={"attributeQueryProfileEnabled"}, havingValue="true")
    @Bean
    @RefreshScope
    public Saml2AttributeQueryProfileHandlerController saml2AttributeQueryProfileHandlerController() {
        return new Saml2AttributeQueryProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlAttributeQueryResponseBuilder, this.casProperties, this.samlObjectSignatureValidator(), this.ticketRegistry, this.samlProfileSamlAttributeQueryFaultResponseBuilder, this.ticketGrantingTicketCookieGenerator, this.samlAttributeQueryTicketFactory);
    }
}

