/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceDefaultCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataResolverCacheLoader;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.ClasspathResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.DynamicMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.FileSystemResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.UrlResourceMetadataResolver;
import org.apereo.cas.support.saml.web.idp.metadata.SamlIdpMetadataAndCertificatesGenerationService;
import org.apereo.cas.support.saml.web.idp.metadata.SamlMetadataController;
import org.apereo.cas.support.saml.web.idp.metadata.TemplatedMetadataAndCertificatesGenerationService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.ResourceBackedMetadataResolver;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@Configuration(value="samlIdPMetadataConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlIdPMetadataConfiguration {
    @Autowired
    @Qualifier(value="noRedirectHttpClient")
    private HttpClient httpClient;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private OpenSamlConfigBean openSamlConfigBean;

    @Lazy
    @Bean
    @DependsOn(value={"shibbolethIdpMetadataAndCertificatesGenerationService"})
    public MetadataResolver casSamlIdPMetadataResolver() {
        try {
            SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
            ResourceBackedMetadataResolver resolver = new ResourceBackedMetadataResolver(ResourceHelper.of((Resource)new FileSystemResource(idp.getMetadata().getMetadataFile())));
            resolver.setParserPool(this.openSamlConfigBean.getParserPool());
            resolver.setFailFastInitialization(idp.getMetadata().isFailFast());
            resolver.setRequireValidMetadata(idp.getMetadata().isRequireValidMetadata());
            resolver.setId(idp.getEntityId());
            resolver.initialize();
            return resolver;
        }
        catch (Exception e) {
            throw new BeanCreationException(e.getMessage(), (Throwable)e);
        }
    }

    @Bean
    @RefreshScope
    public SamlMetadataController samlMetadataController() {
        return new SamlMetadataController(this.shibbolethIdpMetadataAndCertificatesGenerationService());
    }

    @ConditionalOnMissingBean(name={"shibbolethIdpMetadataAndCertificatesGenerationService"})
    @Bean
    public SamlIdpMetadataAndCertificatesGenerationService shibbolethIdpMetadataAndCertificatesGenerationService() {
        return new TemplatedMetadataAndCertificatesGenerationService();
    }

    @ConditionalOnMissingBean(name={"chainingMetadataResolverCacheLoader"})
    @Bean
    @RefreshScope
    public SamlRegisteredServiceMetadataResolverCacheLoader chainingMetadataResolverCacheLoader() {
        return new SamlRegisteredServiceMetadataResolverCacheLoader(this.openSamlConfigBean, this.httpClient, this.casProperties.getAuthn().getSamlIdp(), this.samlRegisteredServiceMetadataResolvers());
    }

    @ConditionalOnMissingBean(name={"samlRegisteredServiceMetadataResolvers"})
    @Bean
    @RefreshScope
    public Collection<SamlRegisteredServiceMetadataResolver> samlRegisteredServiceMetadataResolvers() {
        return CollectionUtils.wrapSet((Object[])new SamlRegisteredServiceMetadataResolver[]{new DynamicMetadataResolver(this.casProperties.getAuthn().getSamlIdp(), this.openSamlConfigBean, this.httpClient), new FileSystemResourceMetadataResolver(this.casProperties.getAuthn().getSamlIdp(), this.openSamlConfigBean), new UrlResourceMetadataResolver(this.casProperties.getAuthn().getSamlIdp(), this.openSamlConfigBean, this.httpClient), new ClasspathResourceMetadataResolver(this.casProperties.getAuthn().getSamlIdp(), this.openSamlConfigBean)});
    }

    @ConditionalOnMissingBean(name={"defaultSamlRegisteredServiceCachingMetadataResolver"})
    @Bean
    @RefreshScope
    public SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver() {
        return new SamlRegisteredServiceDefaultCachingMetadataResolver(this.casProperties.getAuthn().getSamlIdp().getMetadata().getCacheExpirationMinutes(), this.chainingMetadataResolverCacheLoader());
    }
}

