/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services;

import java.util.Optional;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.jasig.cas.client.util.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlIdPEntityIdAuthenticationServiceSelectionStrategy
implements AuthenticationServiceSelectionStrategy {
    private static final long serialVersionUID = -2059445756475980894L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPEntityIdAuthenticationServiceSelectionStrategy.class);
    private final int order = Integer.MIN_VALUE;
    private final ServiceFactory webApplicationServiceFactory;
    private final String casServerPrefix;

    public SamlIdPEntityIdAuthenticationServiceSelectionStrategy(ServiceFactory webApplicationServiceFactory, String casServerPrefix) {
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.casServerPrefix = casServerPrefix;
    }

    public Service resolveServiceFrom(Service service) {
        String entityId = SamlIdPEntityIdAuthenticationServiceSelectionStrategy.getEntityIdAsParameter(service).get().getValue();
        LOGGER.trace("Located entity id [{}] from service authentication request at [{}]", (Object)entityId, (Object)service.getId());
        return this.webApplicationServiceFactory.createService(entityId);
    }

    public boolean supports(Service service) {
        String casPattern = "^".concat(this.casServerPrefix).concat(".*");
        return service != null && service.getId().matches(casPattern) && SamlIdPEntityIdAuthenticationServiceSelectionStrategy.getEntityIdAsParameter(service).isPresent();
    }

    protected static Optional<URIBuilder.BasicNameValuePair> getEntityIdAsParameter(Service service) {
        URIBuilder builder = new URIBuilder(service.getId());
        Optional<URIBuilder.BasicNameValuePair> param = builder.getQueryParams().stream().filter(p -> p.getName().equals("entityId")).findFirst();
        return param;
    }

    public int getOrder() {
        return this.order;
    }
}

