/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataExpirationPolicy;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataResolverCacheLoader;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRegisteredServiceDefaultCachingMetadataResolver
implements SamlRegisteredServiceCachingMetadataResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceDefaultCachingMetadataResolver.class);
    private static final int MAX_CACHE_SIZE = 10000;
    private final long metadataCacheExpirationMinutes;
    private final SamlRegisteredServiceMetadataResolverCacheLoader chainingMetadataResolverCacheLoader;
    private final LoadingCache<SamlRegisteredService, MetadataResolver> cache;

    public SamlRegisteredServiceDefaultCachingMetadataResolver(long metadataCacheExpirationMinutes, SamlRegisteredServiceMetadataResolverCacheLoader loader) {
        this.metadataCacheExpirationMinutes = metadataCacheExpirationMinutes;
        this.chainingMetadataResolverCacheLoader = loader;
        this.cache = Caffeine.newBuilder().maximumSize(10000L).expireAfter((Expiry)new SamlRegisteredServiceMetadataExpirationPolicy(metadataCacheExpirationMinutes)).build((CacheLoader)this.chainingMetadataResolverCacheLoader);
    }

    public MetadataResolver resolve(SamlRegisteredService service) {
        MetadataResolver resolver = null;
        try {
            LOGGER.debug("Resolving metadata for [{}] at [{}].", (Object)service.getName(), (Object)service.getMetadataLocation());
            MetadataResolver metadataResolver = resolver = (MetadataResolver)this.cache.get((Object)service);
            return metadataResolver;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Metadata resolver could not be located from metadata " + service.getMetadataLocation(), e);
        }
        finally {
            if (resolver != null) {
                LOGGER.debug("Loaded and cached SAML metadata [{}] from [{}]", (Object)resolver.getId(), (Object)service.getMetadataLocation());
            }
        }
    }
}

