/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import com.github.benmanes.caffeine.cache.Expiry;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRegisteredServiceMetadataExpirationPolicy
implements Expiry<SamlRegisteredService, MetadataResolver> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceMetadataExpirationPolicy.class);
    private final long defaultExpiration;

    public SamlRegisteredServiceMetadataExpirationPolicy(long metadataCacheExpirationMinutes) {
        this.defaultExpiration = TimeUnit.MINUTES.toNanos(metadataCacheExpirationMinutes);
    }

    public long expireAfterCreate(@Nonnull SamlRegisteredService service, @Nonnull MetadataResolver chainingMetadataResolver, long currentTime) {
        long duration = this.getCacheDurationForServiceProvider(service, chainingMetadataResolver);
        if (duration >= 0L) {
            return duration;
        }
        LOGGER.debug("Metadata for [{}] does not define caching policies", (Object)service.getName());
        if (StringUtils.isNotBlank((CharSequence)service.getMetadataExpirationDuration())) {
            LOGGER.debug("Service [{}] defines a cache expiration duration of [{}]", (Object)service.getName(), (Object)service.getMetadataExpirationDuration());
            return Beans.newDuration((String)service.getMetadataExpirationDuration()).toNanos();
        }
        LOGGER.debug("Service [{}] does not define caching policies. Falling back onto default...", (Object)service.getName());
        return this.defaultExpiration;
    }

    private long getCacheDurationForServiceProvider(SamlRegisteredService service, MetadataResolver chainingMetadataResolver) {
        try {
            CriteriaSet set = new CriteriaSet();
            set.add((Object)new EntityIdCriterion(service.getServiceId()));
            set.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
            EntityDescriptor entitySp = (EntityDescriptor)chainingMetadataResolver.resolveSingle((Object)set);
            if (entitySp.getCacheDuration() != null) {
                LOGGER.debug("Located cache duration [{}] specified in SP metadata for [{}]", (Object)entitySp.getCacheDuration(), (Object)entitySp.getEntityID());
                return TimeUnit.MILLISECONDS.toNanos(entitySp.getCacheDuration());
            }
            set.clear();
            set.add((Object)new EntityIdCriterion(service.getServiceId()));
            EntityDescriptor entity = (EntityDescriptor)chainingMetadataResolver.resolveSingle((Object)set);
            if (entity.getCacheDuration() != null) {
                LOGGER.debug("Located cache duration [{}] specified in entity metadata for [{}]", (Object)entity.getCacheDuration(), (Object)entity.getEntityID());
                return TimeUnit.MILLISECONDS.toNanos(entity.getCacheDuration());
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return -1L;
    }

    public long expireAfterUpdate(@Nonnull SamlRegisteredService service, @Nonnull MetadataResolver chainingMetadataResolver, long currentTime, long currentDuration) {
        return currentDuration;
    }

    public long expireAfterRead(@Nonnull SamlRegisteredService service, @Nonnull MetadataResolver chainingMetadataResolver, long currentTime, long currentDuration) {
        return currentDuration;
    }
}

