/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.util.ArrayList;
import java.util.Collection;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.http.HttpClient;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRegisteredServiceMetadataResolverCacheLoader
implements CacheLoader<SamlRegisteredService, MetadataResolver> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceMetadataResolverCacheLoader.class);
    protected OpenSamlConfigBean configBean;
    protected HttpClient httpClient;
    private final transient Object lock = new Object();
    private final Collection<SamlRegisteredServiceMetadataResolver> availableResolvers;
    private final SamlIdPProperties samlIdPProperties;

    public SamlRegisteredServiceMetadataResolverCacheLoader(OpenSamlConfigBean configBean, HttpClient httpClient, SamlIdPProperties samlIdPProperties, Collection<SamlRegisteredServiceMetadataResolver> availableResolvers) {
        this.configBean = configBean;
        this.httpClient = httpClient;
        this.samlIdPProperties = samlIdPProperties;
        this.availableResolvers = availableResolvers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainingMetadataResolver load(SamlRegisteredService service) {
        try {
            ChainingMetadataResolver metadataResolver = new ChainingMetadataResolver();
            ArrayList metadataResolvers = new ArrayList();
            this.availableResolvers.stream().filter(r -> r.supports(service)).map(r -> r.resolve(service)).forEach(metadataResolvers::addAll);
            if (metadataResolvers.isEmpty()) {
                throw new SamlException("No metadata resolvers could be configured for service " + service.getName() + " with metadata location " + service.getMetadataLocation());
            }
            Object object = this.lock;
            synchronized (object) {
                metadataResolver.setId(ChainingMetadataResolver.class.getCanonicalName());
                metadataResolver.setResolvers(metadataResolvers);
                metadataResolver.initialize();
            }
            return metadataResolver;
        }
        catch (Exception e) {
            throw new SamlException(e.getMessage(), (Throwable)e);
        }
    }
}

