/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.RegexUtils;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.filter.impl.EntityRoleFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.PredicateFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.RequiredValidUntilFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class BaseSamlRegisteredServiceMetadataResolver
implements SamlRegisteredServiceMetadataResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSamlRegisteredServiceMetadataResolver.class);
    protected final SamlIdPProperties samlIdPProperties;
    protected final OpenSamlConfigBean configBean;

    public BaseSamlRegisteredServiceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        this.samlIdPProperties = samlIdPProperties;
        this.configBean = configBean;
    }

    protected void buildSingleMetadataResolver(AbstractMetadataResolver metadataProvider, SamlRegisteredService service) throws Exception {
        SamlIdPProperties.Metadata md = this.samlIdPProperties.getMetadata();
        metadataProvider.setParserPool(this.configBean.getParserPool());
        metadataProvider.setFailFastInitialization(md.isFailFast());
        metadataProvider.setRequireValidMetadata(md.isRequireValidMetadata());
        metadataProvider.setId(metadataProvider.getClass().getCanonicalName());
        this.buildMetadataFilters(service, metadataProvider);
        LOGGER.debug("Initializing metadata resolver from [{}]", (Object)service.getMetadataLocation());
        metadataProvider.initialize();
        LOGGER.info("Initialized metadata resolver from [{}]", (Object)service.getMetadataLocation());
    }

    protected void buildMetadataFilters(SamlRegisteredService service, AbstractMetadataResolver metadataProvider) throws Exception {
        ArrayList<MetadataFilter> metadataFilterList = new ArrayList<MetadataFilter>();
        this.buildRequiredValidUntilFilterIfNeeded(service, metadataFilterList);
        this.buildSignatureValidationFilterIfNeeded(service, metadataFilterList);
        BaseSamlRegisteredServiceMetadataResolver.buildEntityRoleFilterIfNeeded(service, metadataFilterList);
        BaseSamlRegisteredServiceMetadataResolver.buildPredicateFilterIfNeeded(service, metadataFilterList);
        if (!metadataFilterList.isEmpty()) {
            MetadataFilterChain metadataFilterChain = new MetadataFilterChain();
            metadataFilterChain.setFilters(metadataFilterList);
            LOGGER.debug("Metadata filter chain initialized with [{}] filters", (Object)metadataFilterList.size());
            metadataProvider.setMetadataFilter((MetadataFilter)metadataFilterChain);
        }
    }

    private static void buildEntityRoleFilterIfNeeded(SamlRegisteredService service, List<MetadataFilter> metadataFilterList) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)service.getMetadataCriteriaRoles())) {
            ArrayList roles = new ArrayList();
            Set rolesSet = StringUtils.commaDelimitedListToSet((String)service.getMetadataCriteriaRoles());
            rolesSet.stream().forEach(s -> {
                if (s.equalsIgnoreCase(SPSSODescriptor.DEFAULT_ELEMENT_NAME.getLocalPart())) {
                    LOGGER.debug("Added entity role filter [{}]", (Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME);
                    roles.add(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
                }
                if (s.equalsIgnoreCase(IDPSSODescriptor.DEFAULT_ELEMENT_NAME.getLocalPart())) {
                    LOGGER.debug("Added entity role filter [{}]", (Object)IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
                    roles.add(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
                }
            });
            EntityRoleFilter filter = new EntityRoleFilter(roles);
            filter.setRemoveEmptyEntitiesDescriptors(service.isMetadataCriteriaRemoveEmptyEntitiesDescriptors());
            filter.setRemoveRolelessEntityDescriptors(service.isMetadataCriteriaRemoveRolelessEntityDescriptors());
            metadataFilterList.add((MetadataFilter)filter);
            LOGGER.debug("Added entity role filter with roles [{}]", roles);
        }
    }

    private static void buildPredicateFilterIfNeeded(SamlRegisteredService service, List<MetadataFilter> metadataFilterList) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)service.getMetadataCriteriaDirection()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)service.getMetadataCriteriaPattern()) && RegexUtils.isValidRegex((String)service.getMetadataCriteriaPattern())) {
            PredicateFilter.Direction dir = PredicateFilter.Direction.valueOf((String)service.getMetadataCriteriaDirection());
            LOGGER.debug("Metadata predicate filter configuring with direction [{}] and pattern [{}]", (Object)service.getMetadataCriteriaDirection(), (Object)service.getMetadataCriteriaPattern());
            PredicateFilter filter = new PredicateFilter(dir, entityDescriptor -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entityDescriptor.getEntityID()) && entityDescriptor.getEntityID().matches(service.getMetadataCriteriaPattern()));
            metadataFilterList.add((MetadataFilter)filter);
            LOGGER.debug("Added metadata predicate filter with direction [{}] and pattern [{}]", (Object)service.getMetadataCriteriaDirection(), (Object)service.getMetadataCriteriaPattern());
        }
    }

    protected void buildSignatureValidationFilterIfNeeded(SamlRegisteredService service, List<MetadataFilter> metadataFilterList) throws Exception {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)service.getMetadataSignatureLocation())) {
            LOGGER.warn("No metadata signature location is defined for [{}], so SignatureValidationFilter will not be invoked", (Object)service.getMetadataLocation());
            return;
        }
        SignatureValidationFilter signatureValidationFilter = SamlUtils.buildSignatureValidationFilter((String)service.getMetadataSignatureLocation());
        if (signatureValidationFilter != null) {
            signatureValidationFilter.setRequireSignedRoot(false);
            metadataFilterList.add((MetadataFilter)signatureValidationFilter);
            LOGGER.debug("Added metadata SignatureValidationFilter with signature from [{}]", (Object)service.getMetadataSignatureLocation());
        } else {
            LOGGER.warn("Skipped metadata SignatureValidationFilter since signature from [{}] cannot be located", (Object)service.getMetadataLocation());
        }
    }

    protected void buildRequiredValidUntilFilterIfNeeded(SamlRegisteredService service, List<MetadataFilter> metadataFilterList) {
        if (service.getMetadataMaxValidity() > 0L) {
            RequiredValidUntilFilter requiredValidUntilFilter = new RequiredValidUntilFilter(service.getMetadataMaxValidity());
            metadataFilterList.add((MetadataFilter)requiredValidUntilFilter);
            LOGGER.debug("Added metadata RequiredValidUntilFilter with max validity of [{}]", (Object)service.getMetadataMaxValidity());
        } else {
            LOGGER.debug("No metadata maximum validity criteria is defined for [{}], so RequiredValidUntilFilter will not be invoked", (Object)service.getMetadataLocation());
        }
    }
}

