/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.http.HttpClient;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FunctionDrivenDynamicHTTPMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicMetadataResolver.class);
    protected final HttpClient httpClient;

    public DynamicMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean, HttpClient httpClient) {
        super(samlIdPProperties, configBean);
        this.httpClient = httpClient;
    }

    public List<MetadataResolver> resolve(final SamlRegisteredService service) {
        LOGGER.info("Loading metadata dynamically for [{}]", (Object)service.getName());
        SamlIdPProperties.Metadata md = this.samlIdPProperties.getMetadata();
        FunctionDrivenDynamicHTTPMetadataResolver resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClient.getWrappedHttpClient());
        resolver.setMinCacheDuration(Long.valueOf(TimeUnit.MILLISECONDS.convert(md.getCacheExpirationMinutes(), TimeUnit.MINUTES)));
        resolver.setRequireValidMetadata(md.isRequireValidMetadata());
        if (StringUtils.isNotBlank((CharSequence)md.getBasicAuthnPassword()) && StringUtils.isNotBlank((CharSequence)md.getBasicAuthnUsername())) {
            resolver.setBasicCredentials(new UsernamePasswordCredentials(md.getBasicAuthnUsername(), md.getBasicAuthnPassword()));
        }
        if (!md.getSupportedContentTypes().isEmpty()) {
            resolver.setSupportedContentTypes(md.getSupportedContentTypes());
        }
        resolver.setRequestURLBuilder((Function)new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String input) {
                try {
                    if (StringUtils.isNotBlank((CharSequence)input)) {
                        String metadataLocation = service.getMetadataLocation().replace("{0}", EncodingUtils.urlEncode((String)input));
                        LOGGER.info("Constructed dynamic metadata query [{}] for [{}]", (Object)metadataLocation, (Object)service.getName());
                        return metadataLocation;
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        });
        try {
            this.buildSingleMetadataResolver((AbstractMetadataResolver)resolver, service);
            return CollectionUtils.wrap((Object)resolver);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ArrayList<MetadataResolver>(0);
        }
    }

    protected boolean isDynamicMetadataQueryConfigured(SamlRegisteredService service) {
        return service.getMetadataLocation().trim().endsWith("/entities/{0}");
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        return this.isDynamicMetadataQueryConfigured(service);
    }
}

